/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IEParticleTypes;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class AscusBombEntity
extends ThrowableItemProjectile {
    public AscusBombEntity(EntityType<? extends AscusBombEntity> typeIn, Level worldIn) {
        super(typeIn, worldIn);
    }

    public AscusBombEntity(Level world, LivingEntity livingEntity) {
        super((EntityType)IEEntityTypes.ASCUS_BOMB.get(), livingEntity, world);
    }

    protected Item m_7881_() {
        return (Item)IEItems.ASCUS_BOMB.get();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 0.5f);
            this.spawnExplosionCloud();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.initialEffect(result);
            this.spawnLingeringCloud();
        }
    }

    private void spawnExplosionCloud() {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.6, this.m_20189_());
        areaeffectcloudentity.m_19712_(0.1f);
        areaeffectcloudentity.m_19740_(0);
        areaeffectcloudentity.m_19734_(10);
        areaeffectcloudentity.m_19738_(0.0f);
        areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123813_);
        this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
    }

    private void spawnLingeringCloud() {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        areaeffectcloudentity.m_19712_(3.0f);
        areaeffectcloudentity.m_19732_(-0.5f);
        areaeffectcloudentity.m_19740_(10);
        areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 8);
        areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
        areaeffectcloudentity.m_19716_(new MobEffectInstance((MobEffect)IEEffects.INFECTION.get(), 300));
        areaeffectcloudentity.m_19724_((ParticleOptions)IEParticleTypes.INFECTION.get());
        this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
    }

    private void initialEffect(HitResult result) {
        if (!this.f_19853_.m_5776_()) {
            Entity entity = result.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)result).m_82443_() : null;
            AABB axisAlignedBB = this.m_142469_().m_82377_(4.0, 2.0, 4.0);
            List livingEntities = this.f_19853_.m_45976_(LivingEntity.class, axisAlignedBB);
            if (!livingEntities.isEmpty()) {
                for (LivingEntity livingEntity : livingEntities) {
                    double distanceSq = this.m_20280_((Entity)livingEntity);
                    if (!(distanceSq < 16.0)) continue;
                    double durationMultiplier = 1.0 - Math.sqrt(distanceSq) / 4.0;
                    if (livingEntity == entity) {
                        durationMultiplier = 1.0;
                    }
                    int duration = (int)(durationMultiplier * 300.0 + 0.5);
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)IEEffects.INFECTION.get(), duration));
                }
            }
        }
    }
}

