/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.GlowsquitoEntity;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class BlindsightEntity
extends Monster {
    private int jumpDuration;
    private int jumpTicks;
    private Random rand = new Random();

    public BlindsightEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22279_, 0.9).m_22268_(Attributes.f_22277_, 18.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LeapGoal((Mob)this, 6.0));
        this.f_21345_.m_25352_(3, (Goal)new FaceRandomGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new HopGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.BLINDSIGHT_ATTACK_GLOWSQUITO.getBoolean()) {
            this.f_21346_.m_25352_(1, (Goal)new TargetGlowsquitoGoal((Mob)this, true, false));
        }
        if (InfernalExpansionConfig.MobInteractions.BLINDSIGHT_ATTACK_PLAYER.getBoolean()) {
            this.f_21346_.m_25352_(2, new TargetGoal<Player>((Mob)this, Player.class, true, false));
        }
    }

    protected int m_6552_(Player player) {
        return 1 + this.f_19853_.f_46441_.nextInt(4);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IESoundEvents.BLINDSIGHT_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IESoundEvents.BLINDSIGHT_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.BLINDSIGHT_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getJumpCompletion(float adjustTicks) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + adjustTicks) / (float)this.jumpDuration;
    }

    public void m_8107_() {
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
        }
        super.m_8107_();
    }

    protected void m_6135_() {
        this.jumpDuration = 10;
        this.jumpTicks = 0;
        float f = this.m_6118_() + this.rand.nextFloat() * 0.7f;
        Vec3 vector3d = this.m_20184_();
        this.m_20334_(vector3d.f_82479_, f, vector3d.f_82481_);
        if (this.m_20142_()) {
            float f1 = this.m_146908_() * ((float)Math.PI / 180);
            this.m_20256_(this.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f1) * 0.2f), 0.0, (double)(Mth.m_14089_((float)f1) * 0.2f)));
        }
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        }
    }

    public void m_7822_(byte id) {
        if (id == 1) {
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(id);
        }
    }

    protected int getJumpDelay() {
        return (this.rand.nextInt(20) + 10) * 2;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_12387_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19315_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
        if (entityIn instanceof GlowsquitoEntity || entityIn instanceof Player) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.m_6084_() && this.m_142582_((Entity)entityIn) && entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_))) {
            entityIn.m_7292_(new MobEffectInstance((MobEffect)IEEffects.LUMINOUS.get(), 100, 0, true, true));
            entityIn.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 100, 1, true, true));
            this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.m_19970_((LivingEntity)this, (Entity)entityIn);
        }
    }

    public static class MoveHelperController
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final BlindsightEntity blindsight;

        public MoveHelperController(BlindsightEntity blindsightIn) {
            super((Mob)blindsightIn);
            this.blindsight = blindsightIn;
            this.yRot = 180.0f * blindsightIn.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRotIn) {
            this.yRot = yRotIn;
        }

        public void setSpeed(double speedIn) {
            this.f_24978_ = speedIn;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.blindsight.getJumpDelay() / 3;
                        this.blindsight.m_21569_().m_24901_();
                        this.blindsight.m_5496_(this.blindsight.getJumpSound(), this.blindsight.m_6121_(), 1.5f);
                    } else {
                        this.blindsight.f_20900_ = 0.0f;
                        this.blindsight.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class FloatGoal
    extends Goal {
        private final BlindsightEntity blindsight;

        public FloatGoal(BlindsightEntity blindsightIn) {
            this.blindsight = blindsightIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            blindsightIn.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.blindsight.m_20069_() || this.blindsight.m_20077_()) && this.blindsight.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (this.blindsight.m_21187_().nextFloat() < 0.8f) {
                this.blindsight.m_21569_().m_24901_();
            }
            ((MoveHelperController)this.blindsight.m_21566_()).setSpeed(1.2);
        }
    }

    static class AttackGoal
    extends Goal {
        private final BlindsightEntity blindsight;
        private int growTieredTimer;

        public AttackGoal(BlindsightEntity blindsightIn) {
            this.blindsight = blindsightIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.blindsight.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            return this.blindsight.m_21566_() instanceof MoveHelperController;
        }

        public void m_8056_() {
            this.growTieredTimer = 300;
            super.m_8056_();
        }

        public boolean m_8045_() {
            return --this.growTieredTimer > 0 && this.m_8036_();
        }

        public void m_8037_() {
            this.blindsight.m_21391_((Entity)this.blindsight.m_5448_(), 10.0f, 10.0f);
            ((MoveHelperController)this.blindsight.m_21566_()).setDirection(this.blindsight.m_146908_());
        }
    }

    static class LeapGoal
    extends Goal {
        private final Mob leaper;
        private LivingEntity leapTarget;
        private final double maxJumpHeight;

        public LeapGoal(Mob leapingEntity, double maxJumpHeightIn) {
            this.leaper = leapingEntity;
            this.leapTarget = this.leaper.m_5448_();
            this.maxJumpHeight = maxJumpHeightIn;
        }

        public boolean m_8036_() {
            if (this.leaper.m_20160_()) {
                return false;
            }
            this.leapTarget = this.leaper.m_5448_();
            if (this.leapTarget == null || !(this.leapTarget instanceof GlowsquitoEntity)) {
                return false;
            }
            double d0 = this.leapTarget.m_20186_() - this.leaper.m_20186_();
            double d1 = this.leapTarget.m_20185_() - this.leaper.m_20185_();
            double d2 = this.leapTarget.m_20189_() - this.leaper.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d1 * d1 + d2 * d2)));
            if (!(d0 < 1.0 || d0 > this.maxJumpHeight || d3 > 3.0)) {
                if (!this.leaper.m_20096_()) {
                    return false;
                }
                return this.leaper.m_21187_().nextInt(5) == 0;
            }
            return false;
        }

        public void m_8056_() {
            Vec3 vector3d = this.leaper.m_20184_();
            Vec3 vector3d1 = new Vec3(this.leapTarget.m_20185_() - this.leaper.m_20185_(), this.leapTarget.m_20186_() - this.leaper.m_20186_(), this.leapTarget.m_20189_() - this.leaper.m_20189_());
            if (vector3d1.m_82556_() > 1.0E-7) {
                vector3d1 = vector3d1.m_82541_().m_82490_(0.9).m_82549_(vector3d.m_82490_(0.2));
            }
            this.leaper.m_20334_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_);
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final BlindsightEntity blindsight;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(BlindsightEntity blindsightIn) {
            this.blindsight = blindsightIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.blindsight.m_5448_() == null && (this.blindsight.f_19861_ || this.blindsight.m_20069_() || this.blindsight.m_20077_() || this.blindsight.m_21023_(MobEffects.f_19620_)) && this.blindsight.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.blindsight.m_21187_().nextInt(60);
                this.chosenDegrees = this.blindsight.m_21187_().nextInt(360);
            }
            ((MoveHelperController)this.blindsight.m_21566_()).setDirection(this.chosenDegrees);
        }
    }

    static class HopGoal
    extends Goal {
        private final BlindsightEntity blindsight;

        public HopGoal(BlindsightEntity blindsightIn) {
            this.blindsight = blindsightIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.blindsight.m_20159_() && this.blindsight.m_5448_() != null && this.blindsight.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            ((MoveHelperController)this.blindsight.m_21566_()).setSpeed(1.0);
        }
    }

    static class TargetGlowsquitoGoal
    extends NearestAttackableTargetGoal<GlowsquitoEntity> {
        public TargetGlowsquitoGoal(Mob goalOwnerIn, boolean checkSight, boolean nearbyOnlyIn) {
            super(goalOwnerIn, GlowsquitoEntity.class, checkSight, nearbyOnlyIn);
        }

        protected AABB m_7255_(double targetDistance) {
            return this.f_26135_.m_142469_().m_82377_(targetDistance, 4.5, targetDistance);
        }
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(Mob goalOwnerIn, Class<T> targetClassIn, boolean checkSight, boolean nearbyOnlyIn) {
            super(goalOwnerIn, targetClassIn, checkSight, nearbyOnlyIn);
        }

        protected boolean m_26150_(@Nullable LivingEntity potentialTarget, TargetingConditions targetPredicate) {
            return super.m_26150_(potentialTarget, targetPredicate) && (this.f_26135_.m_20280_((Entity)this.f_26050_) <= 10.0 || this.f_26135_.m_20280_((Entity)this.f_26050_) > 10.0 && this.f_26050_.m_21023_((MobEffect)IEEffects.LUMINOUS.get()));
        }
    }
}

