/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.IBucketable;
import org.infernalstudios.infernalexp.entities.IResizable;
import org.infernalstudios.infernalexp.entities.ai.EatItemsGoal;
import org.infernalstudios.infernalexp.entities.ai.TargetWithEffectGoal;
import org.infernalstudios.infernalexp.events.MiscEvents;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class VolineEntity
extends Monster
implements IBucketable,
IResizable {
    private static final Predicate<LivingEntity> TARGETABLE_MAGMA_CUBES = livingEntity -> {
        MagmaCube magmaCubeEntity = (MagmaCube)livingEntity;
        return magmaCubeEntity.m_33633_() && !magmaCubeEntity.m_8077_();
    };
    private static final EntityDataAccessor<Float> VOLINE_SIZE = SynchedEntityData.m_135353_(VolineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(VolineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean isEating;

    public VolineEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setEntitySize(1.0f + this.f_19853_.m_5822_().nextFloat() * 0.4f);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new VolineEatItemsGoal(this, MiscEvents.getVolineEatTable(), 32.0, this.m_21133_(Attributes.f_22279_) * 2.0));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_) * 1.2, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_)));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractPiglin.class, 16.0f, this.m_21133_(Attributes.f_22279_) * 2.0, this.m_21133_(Attributes.f_22279_) * 1.5));
        this.f_21345_.m_25352_(5, (Goal)new PanicGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_) * 2.0));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.VOLINE_ATTACK_FIRE_RESISTANCE.getBoolean()) {
            this.f_21346_.m_25352_(1, (Goal)new TargetWithEffectGoal((Mob)this, LivingEntity.class, true, false, MobEffects.f_19607_, null));
        }
        if (InfernalExpansionConfig.MobInteractions.VOLINE_ATTACK_PLAYER.getBoolean()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
        if (InfernalExpansionConfig.MobInteractions.VOLINE_ATTACK_MAGMA_CUBE.getBoolean()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, MagmaCube.class, 10, true, true, TARGETABLE_MAGMA_CUBES));
        }
    }

    public void m_8107_() {
        if (this.m_21133_(Attributes.f_22279_) <= 0.0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20208_(0.5), this.m_20186_() + 1.6, this.m_20262_(0.5), 0.0, 0.07, 0.0);
        }
        super.m_8107_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VOLINE_SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public float getEntitySize() {
        return ((Float)this.f_19804_.m_135370_(VOLINE_SIZE)).floatValue();
    }

    @Override
    public void setEntitySize(float size) {
        size = Math.min(size, 2.0f);
        this.f_19804_.m_135381_(VOLINE_SIZE, (Object)Float.valueOf(size));
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.5f - (size - 1.0f) / 2.0f));
    }

    @Override
    public boolean isFromBucket() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Size", this.getEntitySize());
        compound.m_128379_("FromBucket", this.isFromBucket());
    }

    public void m_7378_(CompoundTag compound) {
        float size = Math.max(compound.m_128457_("Size"), 1.0f);
        this.setEntitySize(size);
        this.setFromBucket(compound.m_128471_("FromBucket"));
        super.m_7378_(compound);
    }

    public void m_6210_() {
        super.m_6210_();
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(0.85f * this.getEntitySize());
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (VOLINE_SIZE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    protected int m_6552_(Player player) {
        return 1 + this.f_19853_.f_46441_.nextInt(4);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IESoundEvents.VOLINE_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IESoundEvents.VOLINE_HURT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.VOLINE_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    public boolean m_5825_() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEating() {
        return this.isEating;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 8) {
            this.isEating = false;
        } else if (id == 9) {
            this.isEating = true;
        } else {
            super.m_7822_(id);
        }
    }

    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        return IBucketable.tryBucketEntity(playerIn, hand, this).orElse(super.m_6071_(playerIn, hand));
    }

    @Override
    public void copyToStack(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41784_();
        IBucketable.copyToStack((Mob)this, stack);
        compoundNBT.m_128350_("Size", this.getEntitySize());
    }

    @Override
    public void copyFromAdditional(CompoundTag compound) {
        IBucketable.copyFromAdditional((Mob)this, compound);
        if (compound.m_128425_("Size", 99)) {
            this.setEntitySize(compound.m_128457_("Size"));
        }
    }

    @Override
    public SoundEvent getBucketedSound() {
        return SoundEvents.f_11783_;
    }

    @Override
    public ItemStack getBucketItem() {
        return new ItemStack((ItemLike)IEItems.VOLINE_BUCKET.get());
    }

    public static class VolineEatItemsGoal
    extends EatItemsGoal<VolineEntity> {
        private final Map<Item, Map<Item, Integer>> eatItemsMap;

        public VolineEatItemsGoal(VolineEntity entityIn, Map<Item, Map<Item, Integer>> itemsToEat, double range, double speedIn) {
            super(entityIn, itemsToEat.keySet(), range, speedIn);
            this.eatItemsMap = itemsToEat;
        }

        @Override
        public void consumeItem() {
            Map<Item, Integer> eatItem;
            ((VolineEntity)this.entityIn).setEntitySize(((VolineEntity)this.entityIn).getEntitySize() + 0.2f);
            Item itemReference = this.itemInstance.m_32055_().m_41720_();
            super.consumeItem();
            if (itemReference == Items.f_42436_) {
                ((VolineEntity)this.entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1));
                ((VolineEntity)this.entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19617_, 2400, 0));
            }
            if ((eatItem = this.eatItemsMap.get(itemReference)) != null) {
                for (Map.Entry<Item, Integer> item : eatItem.entrySet()) {
                    ((VolineEntity)this.entityIn).m_5552_(new ItemStack((ItemLike)item.getKey(), item.getValue().intValue()), 1.0f);
                }
            }
        }
    }
}

