/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.events;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.infernalstudios.infernalexp.init.IECarvers;
import org.infernalstudios.infernalexp.init.IEFeatures;
import org.infernalstudios.infernalexp.init.IEPlacedFeatures;
import org.infernalstudios.infernalexp.init.IEStructures;

@Mod.EventBusSubscriber(modid="infernalexp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WorldEvents {
    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IEFeatures.features.forEach(feature -> event.getRegistry().register((IForgeRegistryEntry)feature));
    }

    @SubscribeEvent
    public static void registerStructures(RegistryEvent.Register<StructureFeature<?>> event) {
        IEStructures.structures.forEach(structure -> event.getRegistry().register((IForgeRegistryEntry)structure));
    }

    @SubscribeEvent
    public static void registerWorldCarvers(RegistryEvent.Register<WorldCarver<?>> event) {
        IECarvers.carvers.forEach(carver -> event.getRegistry().register((IForgeRegistryEntry)carver));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        ResourceLocation name = event.getName();
        ResourceKey biome = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)name);
        if (biome == Biomes.f_48200_) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, IEPlacedFeatures.ORE_GLOWSILK_COCOON);
            event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, IEPlacedFeatures.PATCH_CRIMSON_CAP);
            event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, IEPlacedFeatures.SHROOMLIGHT_TEAR);
        } else if (biome == Biomes.f_48175_) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, IEPlacedFeatures.ORE_GLOWSILK_COCOON);
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, IEPlacedFeatures.ORE_BASALT_IRON_BASALT_DELTA);
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, IEPlacedFeatures.BASALTIC_MAGMA);
        } else if (biome == Biomes.f_48201_) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, IEPlacedFeatures.PATCH_WARPED_CAP);
            event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, IEPlacedFeatures.SHROOMLIGHT_TEAR);
        } else if (biome == Biomes.f_48199_) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, IEPlacedFeatures.ORE_BASALT_IRON_BASALT_DELTA);
            event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, IEPlacedFeatures.PATCH_BURIED_BONE);
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, IEPlacedFeatures.ORE_SOUL_STONE);
        } else if (biome == Biomes.f_48209_) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, IEPlacedFeatures.PATCH_PLANTED_QUARTZ);
        }
    }
}

