/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.world.biome.IEBiome;
import org.infernalstudios.infernalexp.world.biome.netherbiomes.GlowstoneCanyonBiome;

public class IEBiomes {
    private static final List<Pair<ResourceKey<Biome>, Climate.ParameterPoint>> biomeParameters = new ArrayList<Pair<ResourceKey<Biome>, Climate.ParameterPoint>>();
    private static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"infernalexp");
    public static ResourceKey<Biome> GLOWSTONE_CANYON = IEBiomes.registerBiome("glowstone_canyon", new GlowstoneCanyonBiome());

    private static ResourceKey<Biome> registerBiome(String name, IEBiome biome) {
        ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("infernalexp", name));
        BiomeDictionary.addTypes((ResourceKey)resourceKey, (BiomeDictionary.Type[])biome.getBiomeTypes());
        biomeParameters.add((Pair<ResourceKey<Biome>, Climate.ParameterPoint>)Pair.of((Object)resourceKey, (Object)biome.getBiomeParameters()));
        BIOMES.register(name, biome::build);
        return resourceKey;
    }

    public static void register(IEventBus eventBus) {
        BIOMES.register(eventBus);
        InfernalExpansion.LOGGER.info("Infernal Expansion: Biomes Registered!");
    }

    public static List<Pair<ResourceKey<Biome>, Climate.ParameterPoint>> getBiomeParameters() {
        return biomeParameters;
    }
}

