/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.util.ShapeUtil;
import org.infernalstudios.infernalexp.world.gen.features.IEFeature;

public class BoulderFeature
extends IEFeature<BlockStateConfiguration> {
    public BoulderFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean placeFeature(FeaturePlaceContext<BlockStateConfiguration> context) {
        int radius = (new int[]{1, 1, 2, 2, 2, 2, 3})[context.m_159776_().nextInt(7)];
        if (!context.m_159774_().m_46859_(context.m_159777_()) || context.m_159774_().m_8055_(context.m_159777_().m_7495_()).m_60734_() != IEBlocks.GLOWDUST_SAND.get() || context.m_159774_().m_46859_(context.m_159777_().m_6625_(radius)) || context.m_159776_().nextInt(3) == 2) {
            return false;
        }
        this.placeSphere(context.m_159774_(), context.m_159776_(), context.m_159777_().m_6625_(Math.floorDiv(radius, 3)), radius, (BlockStateConfiguration)context.m_159778_());
        return true;
    }

    @Override
    boolean shouldPlaceOnStructures() {
        return false;
    }

    private void placeSphere(WorldGenLevel world, Random random, BlockPos pos, int radius, BlockStateConfiguration config) {
        for (BlockPos point : ShapeUtil.generateSolidSphere(radius)) {
            world.m_7731_(pos.m_141952_((Vec3i)point), config.f_67547_, 2);
            this.randomNoise(world, random, pos, config);
        }
    }

    private void randomNoise(WorldGenLevel world, Random random, BlockPos pos, BlockStateConfiguration config) {
        switch (random.nextInt(8)) {
            case 0: {
                if (!world.m_8055_(pos.m_142125_().m_7495_()).m_60795_()) {
                    world.m_7731_(pos.m_142125_(), config.f_67547_, 2);
                }
            }
            case 1: {
                if (!world.m_8055_(pos.m_142127_().m_7495_()).m_60795_()) {
                    world.m_7731_(pos.m_142127_(), config.f_67547_, 2);
                }
            }
            case 2: {
                if (!world.m_8055_(pos.m_142126_().m_7495_()).m_60795_()) {
                    world.m_7731_(pos.m_142126_(), config.f_67547_, 2);
                }
            }
            case 3: {
                if (!world.m_8055_(pos.m_142128_().m_7495_()).m_60795_()) {
                    world.m_7731_(pos.m_142128_(), config.f_67547_, 2);
                }
            }
            case 4: {
                if (world.m_8055_(pos.m_7494_().m_7495_()).m_60795_()) break;
                world.m_7731_(pos.m_7494_(), config.f_67547_, 2);
            }
        }
    }
}

