/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.structures;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import org.infernalstudios.infernalexp.world.gen.structures.StructureUtil;
import org.jetbrains.annotations.NotNull;

public class StriderAltarStructure
extends StructureFeature<JigsawConfiguration> {
    private static final int MIN_VALID_SPACE = 20;

    public StriderAltarStructure() {
        super(JigsawConfiguration.f_67756_, StriderAltarStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    @NotNull
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    @NotNull
    private static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos pos = context.f_197355_().m_151394_(0);
        NoiseColumn column = context.f_197352_().m_141914_(pos.m_123341_(), pos.m_123343_(), context.f_197357_());
        int maxHeight = Math.min(context.f_197352_().m_6331_(), context.f_197352_().m_6337_() + 20);
        for (int y = context.f_197352_().m_6337_(); y < maxHeight; ++y) {
            if (column.m_183556_(y).m_60795_()) continue;
            return Optional.empty();
        }
        Optional<Integer> yLevel = StructureUtil.getNetherLavaFloorY(context, pos);
        if (yLevel.isEmpty()) {
            return Optional.empty();
        }
        pos = pos.m_6630_(yLevel.get().intValue());
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)pos, (boolean)false, (boolean)false);
    }
}

