/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi;

import frankv.jmi.JMI;
import frankv.jmi.jmoverlay.JMOverlayManager;
import frankv.jmi.jmoverlay.waystones.WaystoneMarker;
import frankv.jmi.util.OverlayHelper;
import java.util.EnumSet;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.event.ClientEvent;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.KnownWaystonesEvent;

@ParametersAreNonnullByDefault
@ClientPlugin
public class JMIJourneyMapPlugin
implements IClientPlugin {
    private IClientAPI jmAPI = null;

    public void initialize(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
        try {
            if (JMI.waystones) {
                Balm.getEvents().onEvent(KnownWaystonesEvent.class, WaystoneMarker.INSTANCE::onKnownWaystones);
            }
        }
        catch (NoClassDefFoundError e) {
            JMI.waystones = false;
        }
        JMI.platformEventListener.register();
        JMOverlayManager.INSTANCE.setJmAPI(jmAPI);
        OverlayHelper.setJmAPI(jmAPI);
        this.jmAPI.subscribe(this.getModId(), EnumSet.of(ClientEvent.Type.MAPPING_STARTED, new ClientEvent.Type[]{ClientEvent.Type.MAPPING_STOPPED, ClientEvent.Type.MAP_CLICKED, ClientEvent.Type.MAP_DRAGGED, ClientEvent.Type.MAP_MOUSE_MOVED, ClientEvent.Type.REGISTRY}));
        JMI.LOGGER.info("Initialized " + this.getClass().getName());
    }

    public String getModId() {
        return "jmi";
    }

    public void onEvent(ClientEvent event) {
        try {
            switch (event.type) {
                case MAPPING_STARTED: {
                    JMI.platformEventListener.setFirstLogin(false);
                    break;
                }
                case MAPPING_STOPPED: {
                    this.jmAPI.removeAll("jmi");
                    JMI.LOGGER.debug("all overlays removed");
                }
            }
            JMOverlayManager.INSTANCE.getToggleableOverlays().values().forEach(o -> o.onJMEvent(event));
        }
        catch (Throwable t) {
            JMI.LOGGER.error(t.getMessage(), t);
        }
    }
}

