/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.datafixers.DataFixer;
import journeymap.client.io.nbt.CustomChunkReader;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import org.apache.logging.log4j.Logger;

public class JMChunkLoader {
    private static Logger logger = Journeymap.getLogger();

    public static ChunkMD getChunkMD(ChunkStorage loader, Minecraft mc, ChunkPos coord, boolean forceRetain) {
        if (RegionLoader.getRegionFile(mc, coord.f_45578_, coord.f_45579_).exists()) {
            IntegratedServer integratedServer = mc.m_91092_();
            ServerLevel serverWorld = integratedServer.m_129880_(mc.f_91074_.f_19853_.m_46472_());
            return JMChunkLoader.getChunkFromRegion(serverWorld, coord, loader, forceRetain);
        }
        logger.warn("Region doesn't exist for chunk: " + coord);
        return null;
    }

    private static ChunkMD getChunkFromRegion(ServerLevel world, ChunkPos coord, ChunkStorage loader, boolean forceRetain) {
        try {
            CompoundTag nbt = loader.m_63512_(coord);
            if (nbt != null) {
                return JMChunkLoader.getChunkFromNBT(world, coord, nbt, forceRetain);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ChunkMD getChunkFromNBT(ServerLevel world, ChunkPos coord, CompoundTag nbt, boolean forceRetain) {
        DataFixer fixer = Minecraft.m_91087_().m_91295_();
        int dataVersion = ChunkStorage.m_63505_((CompoundTag)nbt);
        nbt = NbtUtils.m_129213_((DataFixer)fixer, (DataFixTypes)DataFixTypes.CHUNK, (CompoundTag)nbt, (int)dataVersion);
        CustomChunkReader.ProcessedChunk processedChunk = CustomChunkReader.read(world, world.m_8904_(), coord, nbt);
        if (processedChunk != null && processedChunk.chunk() != null) {
            return new ChunkMD(processedChunk.chunk(), forceRetain, processedChunk.light());
        }
        return null;
    }

    public static ChunkMD getChunkMdFromMemory(Level level, int chunkX, int chunkZ) {
        LevelChunk theChunk;
        ChunkSource provider;
        if (level != null && level == Minecraft.m_91087_().f_91074_.f_19853_ && (provider = level.m_7726_()) != null && (theChunk = level.m_6325_(chunkX, chunkZ)) != null && !(theChunk instanceof EmptyLevelChunk) && theChunk.m_62953_() == Minecraft.m_91087_().f_91074_.f_19853_) {
            return new ChunkMD(theChunk);
        }
        return null;
    }
}

