/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.server.ai.AvoidProjectilesGoal;
import com.bobmowzie.mowziesmobs.server.ai.NearestAttackableTargetPredicateGoal;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoaVillager;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityBarakoaya
extends EntityBarakoaVillager {
    public boolean hasTriedOrSucceededTeleport = true;
    private int teleportAttempts = 0;

    public EntityBarakoaya(EntityType<? extends EntityBarakoaVillager> type, Level world) {
        super(type, world);
        this.setWeapon(3);
        this.setMask(MaskType.FAITH);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new HealTargetGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 50.0f, 0.8, 0.6, target -> {
            if (target instanceof Player) {
                if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                if (this.m_5448_() == target) {
                    return true;
                }
                if (this.m_5448_() instanceof EntityBarako) {
                    return false;
                }
                if (this.getAnimation() != NO_ANIMATION) {
                    return false;
                }
                ItemStack headArmorStack = (ItemStack)((Player)target).m_150109_().f_35975_.get(3);
                return !(headArmorStack.m_41720_() instanceof BarakoaMask) || target == this.getMisbehavedPlayer();
            }
            return true;
        }){

            public void m_8041_() {
                super.m_8041_();
                EntityBarakoaya.this.setMisbehavedPlayerId(null);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new TeleportToSafeSpotGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidProjectilesGoal(this, Projectile.class, target -> this.getAnimation() == HEAL_LOOP_ANIMATION || this.getAnimation() == HEAL_START_ANIMATION, 3.0f, 0.8, 0.6));
    }

    @Override
    protected void registerTargetGoals() {
        super.registerTargetGoals();
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetPredicateGoal<EntityBarako>((Mob)this, EntityBarako.class, 0, false, false, TargetingConditions.m_148353_().m_26883_(this.m_21133_(Attributes.f_22277_) * 2.0).m_26888_(target -> {
            if (!this.active) {
                return false;
            }
            if (target instanceof Mob) {
                return ((Mob)target).m_5448_() != null || target.m_21223_() < target.m_21233_();
            }
            return false;
        }).m_148355_().m_26893_()){

            public boolean m_8045_() {
                LivingEntity livingentity = this.f_26135_.m_5448_();
                if (livingentity == null) {
                    livingentity = this.f_26137_;
                }
                boolean targetHasTarget = false;
                if (livingentity instanceof Mob) {
                    targetHasTarget = ((Mob)livingentity).m_5448_() != null;
                }
                boolean canHeal = true;
                if (this.f_26135_ instanceof EntityBarakoa) {
                    canHeal = ((EntityBarakoa)this.f_26135_).canHeal(livingentity);
                }
                return super.m_8045_() && (livingentity.m_21223_() < livingentity.m_21233_() || targetHasTarget) && canHeal;
            }

            protected double m_7623_() {
                return super.m_7623_() * 2.0;
            }
        });
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.active && this.teleportAttempts > 3 && (this.m_5448_() == null || !this.m_5448_().m_6084_())) {
            this.hasTriedOrSucceededTeleport = true;
        }
        if (this.getAnimation() == HEAL_LOOP_ANIMATION && !this.canHeal(this.m_5448_())) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, HEAL_STOP_ANIMATION);
        }
    }

    @Override
    protected void updateAttackAI() {
    }

    @Override
    public boolean canHeal(LivingEntity entity) {
        return entity instanceof EntityBarako;
    }

    @Override
    public void m_6667_(DamageSource cause) {
        if (this.m_5448_() instanceof EntityBarako) {
            Mob damagingMob;
            List targetingMobs = this.f_19853_.m_6443_(Mob.class, this.m_142469_().m_82400_(30.0), e -> e.m_5448_() == this);
            if (cause.m_7639_() instanceof Mob && (damagingMob = (Mob)cause.m_7639_()).m_5448_() == this && !targetingMobs.contains(damagingMob)) {
                targetingMobs.add(damagingMob);
            }
            for (Mob mob : targetingMobs) {
                mob.m_6710_(this.m_5448_());
            }
        }
        super.m_6667_(cause);
    }

    @Override
    protected void sunBlockTarget() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            EffectHandler.addOrCombineEffect(target, EffectHandler.SUNBLOCK, 20, 0, true, false);
            if (target.f_19797_ % 20 == 0) {
                target.m_5634_(0.15f);
            }
        }
    }

    public boolean m_6673_(DamageSource source) {
        boolean teleporting = this.getAnimation() == TELEPORT_ANIMATION && this.getAnimationTick() <= 16;
        return super.m_6673_(source) || (!this.active || teleporting || !this.hasTriedOrSucceededTeleport) && source != DamageSource.f_19317_ && this.timeUntilDeath != 0;
    }

    public void m_20254_(int seconds) {
        boolean teleporting;
        boolean bl = teleporting = this.getAnimation() == TELEPORT_ANIMATION && this.getAnimationTick() <= 16;
        if (!this.active || teleporting || !this.hasTriedOrSucceededTeleport) {
            return;
        }
        super.m_20254_(seconds);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingData, CompoundTag compound) {
        this.setMask(MaskType.FAITH);
        this.setWeapon(3);
        return super.m_6518_(world, difficulty, reason, livingData, compound);
    }

    public static class HealTargetGoal
    extends Goal {
        private final EntityBarakoa entity;

        public HealTargetGoal(EntityBarakoa entityIn) {
            this.entity = entityIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8045_() {
            return this.entity.canHeal(this.entity.m_5448_());
        }

        public boolean m_8036_() {
            if (!this.entity.active) {
                return false;
            }
            return this.entity.canHeal(this.entity.m_5448_());
        }

        public void m_8056_() {
            super.m_8056_();
            AnimationHandler.INSTANCE.sendAnimationMessage(this.entity, EntityBarakoa.HEAL_START_ANIMATION);
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    public class TeleportToSafeSpotGoal
    extends Goal {
        private final EntityBarakoaya entity;

        public TeleportToSafeSpotGoal(EntityBarakoaya entityIn) {
            this.entity = entityIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.entity.active) {
                return false;
            }
            if (this.entity.getAnimation() == EntityBarakoa.TELEPORT_ANIMATION) {
                return false;
            }
            if (this.entity.m_5448_() != null && this.entity.canHeal(this.entity.m_5448_()) && (this.entity.targetDistance >= 0.0f && this.entity.targetDistance < 7.0f || !EntityBarakoaya.this.hasTriedOrSucceededTeleport)) {
                return this.findTeleportLocation();
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            EntityBarakoaya.this.hasTriedOrSucceededTeleport = true;
            AnimationHandler.INSTANCE.sendAnimationMessage(this.entity, EntityBarakoa.TELEPORT_ANIMATION);
        }

        private boolean findTeleportLocation() {
            int k;
            int j;
            int i;
            if (this.entity.m_21535_() > -1.0f) {
                i = Mth.m_14143_((float)this.entity.m_21534_().m_123341_());
                j = Mth.m_14143_((float)this.entity.m_21534_().m_123342_());
                k = Mth.m_14143_((float)this.entity.m_21534_().m_123343_());
            } else if (this.entity.m_5448_() != null) {
                i = Mth.m_14107_((double)this.entity.m_5448_().m_20185_());
                j = Mth.m_14107_((double)this.entity.m_5448_().m_20186_());
                k = Mth.m_14107_((double)this.entity.m_5448_().m_20189_());
            } else {
                i = Mth.m_14107_((double)this.entity.m_20185_());
                j = Mth.m_14107_((double)this.entity.m_20186_());
                k = Mth.m_14107_((double)this.entity.m_20189_());
            }
            boolean foundPosition = false;
            for (int l = 0; l < 50; ++l) {
                LivingEntity target;
                double radius = Math.pow(EntityBarakoaya.this.f_19796_.nextFloat(), 1.35) * 25.0;
                double angle = (double)EntityBarakoaya.this.f_19796_.nextFloat() * Math.PI * 2.0;
                int i1 = i + (int)(Math.cos(angle) * radius);
                int j1 = j + Mth.m_14072_((Random)this.entity.f_19796_, (int)0, (int)15) * Mth.m_14072_((Random)this.entity.f_19796_, (int)-1, (int)1);
                int k1 = k + (int)(Math.sin(angle) * radius);
                BlockPos blockpos = new BlockPos(i1, j1, k1);
                Vec3 newPos = new Vec3((double)i1, (double)j1, (double)k1);
                Vec3 offset = newPos.m_82546_(this.entity.m_20182_());
                AABB newBB = this.entity.m_142469_().m_82383_(offset);
                if (!this.testBlock(blockpos, newBB) || !this.entity.f_19853_.m_45976_(EntityBarako.class, newBB.m_82400_(7.0)).isEmpty()) continue;
                this.entity.teleportDestination = newPos.m_82520_(0.0, 0.0, 0.0);
                if (this.entity.teleportAttempts >= 3) {
                    foundPosition = true;
                }
                if (!this.entity.f_19853_.m_45976_(EntityBarakoaya.class, newBB.m_82400_(5.0)).isEmpty()) continue;
                if (this.entity.teleportAttempts >= 2) {
                    foundPosition = true;
                }
                if (this.entity.f_19853_.m_45914_((double)i1, (double)j1, (double)k1, 5.0) || this.entity.f_19853_.m_46855_(newBB)) continue;
                if (this.entity.teleportAttempts >= 1) {
                    foundPosition = true;
                }
                if ((target = EntityBarakoaya.this.m_5448_()) instanceof Mob && ((Mob)target).m_5448_() != null) {
                    if (this.canEntityBeSeenFromLocation((Entity)((Mob)target).m_5448_(), newPos)) continue;
                    return true;
                }
                return true;
            }
            ++this.entity.teleportAttempts;
            if (this.entity.teleportAttempts > 3) {
                EntityBarakoaya.this.hasTriedOrSucceededTeleport = true;
            }
            return foundPosition;
        }

        public boolean canEntityBeSeenFromLocation(Entity entityIn, Vec3 location) {
            Vec3 vector3d1;
            Vec3 vector3d = new Vec3(location.m_7096_(), location.m_7098_() + (double)this.entity.m_20192_(), location.m_7094_());
            return this.entity.f_19853_.m_45547_(new ClipContext(vector3d, vector3d1 = new Vec3(entityIn.m_20185_(), entityIn.m_20188_(), entityIn.m_20189_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity)).m_6662_() != HitResult.Type.BLOCK;
        }

        public boolean testBlock(BlockPos blockpos, AABB aabb) {
            Level world = this.entity.f_19853_;
            if (world.m_46805_(blockpos)) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = world.m_8055_(blockpos1);
                return blockstate.m_60767_().m_76333_() && blockstate.m_60767_().m_76334_() && world.m_45772_(aabb);
            }
            return false;
        }
    }
}

