/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.sculptor;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ai.UseAbilityAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderPlatform;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityPillar;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerSculptorTrade;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class EntitySculptor
extends MowzieGeckoEntity {
    public static int TEST_HEIGHT = 40;
    public static int TEST_RADIUS = 16;
    public static final AbilityType<EntitySculptor, StartTestAbility> START_TEST = new AbilityType<EntitySculptor, StartTestAbility>("testStart", StartTestAbility::new);
    public static final AbilityType<EntitySculptor, EndTestAbility> END_TEST = new AbilityType<EntitySculptor, EndTestAbility>("testEnd", EndTestAbility::new);
    private static final EntityDataAccessor<ItemStack> DESIRES = SynchedEntityData.m_135353_(EntitySculptor.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> IS_TRADING = SynchedEntityData.m_135353_(EntitySculptor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean handLOpen = true;
    public boolean handROpen = true;
    private Player customer;
    private Player testingPlayer;
    private Optional<Double> prevPlayerVelY;
    private Optional<Vec3> prevPlayerPosition;
    private int ticksAcceleratingUpward;
    private boolean testing;
    private EntityPillar pillar;

    public EntitySculptor(EntityType<? extends MowzieEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntitySculptor>(this, START_TEST));
    }

    protected void m_8097_() {
        super.m_8097_();
        Item tradeItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)ConfigHandler.COMMON.MOBS.BARAKO.whichItem.get()));
        this.m_20088_().m_135372_(DESIRES, (Object)new ItemStack((ItemLike)tradeItem, ((Integer)ConfigHandler.COMMON.MOBS.BARAKO.howMany.get()).intValue()));
        this.m_20088_().m_135372_(IS_TRADING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void setDesires(ItemStack stack) {
        this.m_20088_().m_135381_(DESIRES, (Object)stack);
    }

    public ItemStack getDesires() {
        return (ItemStack)this.m_20088_().m_135370_(DESIRES);
    }

    public boolean fulfillDesire(Slot input) {
        ItemStack desires = this.getDesires();
        if (EntitySculptor.canPayFor(input.m_7993_(), desires)) {
            input.m_6201_(desires.m_41613_());
            return true;
        }
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.testing && !this.f_19853_.m_5776_()) {
            if (this.testingPlayer == null) {
                this.sendAbilityMessage(END_TEST);
                this.prevPlayerPosition = Optional.empty();
                this.prevPlayerVelY = Optional.empty();
            } else {
                if (this.testingPlayer.m_150110_().f_35935_) {
                    this.playerCheated(this.testingPlayer);
                }
                if (!this.testingPlayer.m_20096_()) {
                    double playerVelY = this.testingPlayer.m_20184_().m_7098_();
                    if (this.prevPlayerVelY != null && this.prevPlayerVelY.isPresent()) {
                        double acceleration = playerVelY - this.prevPlayerVelY.get();
                        if (acceleration >= 0.0) {
                            ++this.ticksAcceleratingUpward;
                        } else if (this.ticksAcceleratingUpward > 0) {
                            --this.ticksAcceleratingUpward;
                        }
                        if (this.ticksAcceleratingUpward > 5) {
                            this.playerCheated(this.testingPlayer);
                        }
                    }
                    this.prevPlayerVelY = Optional.of(playerVelY);
                } else {
                    this.ticksAcceleratingUpward = 0;
                    this.prevPlayerVelY = Optional.empty();
                }
                Vec3 currPosition = this.testingPlayer.m_20182_();
                if (this.prevPlayerPosition != null && this.prevPlayerPosition.isPresent() && currPosition.m_82554_(this.prevPlayerPosition.get()) > 3.0) {
                    this.playerCheated(this.testingPlayer);
                }
                this.prevPlayerPosition = Optional.of(currPosition);
            }
        }
    }

    public void playerCheated(Player player) {
        if (player == this.testingPlayer) {
            this.sendAbilityMessage(END_TEST);
        }
    }

    public void setTrading(boolean trading) {
        this.f_19804_.m_135381_(IS_TRADING, (Object)trading);
    }

    public boolean isTrading() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRADING);
    }

    public Player getCustomer() {
        return this.customer;
    }

    public void setCustomer(Player customer) {
        this.setTrading(customer != null);
        this.customer = customer;
    }

    public void openGUI(Player playerEntity) {
        this.setCustomer(playerEntity);
        MowziesMobs.PROXY.setReferencedMob((Entity)this);
        if (!this.f_19853_.f_46443_ && this.m_5448_() == null && this.m_6084_()) {
            playerEntity.m_5893_(new MenuProvider(){

                public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                    return new ContainerSculptorTrade(id, EntitySculptor.this, playerInventory);
                }

                public Component m_5446_() {
                    return EntitySculptor.this.m_5446_();
                }
            });
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.canTradeWith(player) && this.m_5448_() == null && this.m_6084_()) {
            this.openGUI(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canTradeWith(Player player) {
        return !this.isTrading() && !(this.m_21223_() <= 0.0f) && !this.testing;
    }

    public boolean doesItemSatisfyDesire(ItemStack stack) {
        return EntitySculptor.canPayFor(stack, this.getDesires());
    }

    private static boolean canPayFor(ItemStack stack, ItemStack worth) {
        return stack.m_41720_() == worth.m_41720_() && stack.m_41613_() >= worth.m_41613_();
    }

    public EntityPillar getPillar() {
        return this.pillar;
    }

    private <ENTITY extends IAnimatable> void instructionListener(CustomInstructionKeyframeEvent<ENTITY> event) {
        if (event.instructions.contains("closeHandR")) {
            this.handROpen = false;
        }
        if (event.instructions.contains("closeHandL")) {
            this.handLOpen = false;
        }
        if (event.instructions.contains("openHandR")) {
            this.handROpen = true;
        }
        if (event.instructions.contains("openHandL")) {
            this.handLOpen = true;
        }
    }

    @Override
    public void registerControllers(AnimationData data) {
        super.registerControllers(data);
        this.controller.registerCustomInstructionListener(this::instructionListener);
    }

    @Override
    public AbilityType<?, ?>[] getAbilities() {
        return new AbilityType[]{START_TEST, END_TEST};
    }

    public static class EndTestAbility
    extends Ability<EntitySculptor> {
        public EndTestAbility(AbilityType<EntitySculptor, EndTestAbility> abilityType, EntitySculptor user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 20)});
        }

        @Override
        public boolean tryAbility() {
            return ((EntitySculptor)this.getUser()).pillar != null;
        }

        @Override
        public void start() {
            super.start();
            this.playAnimation("testStart", false);
            if (((EntitySculptor)this.getUser()).pillar != null) {
                ((EntitySculptor)this.getUser()).pillar.startFalling();
            }
        }

        @Override
        public void tick() {
            super.tick();
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE && (((EntitySculptor)this.getUser()).pillar == null || ((EntitySculptor)this.getUser()).pillar.m_146910_())) {
                this.nextSection();
            }
        }

        @Override
        public void end() {
            super.end();
            if (this.getUser() != null) {
                ((EntitySculptor)this.getUser()).pillar = null;
                ((EntitySculptor)this.getUser()).testingPlayer = null;
                ((EntitySculptor)this.getUser()).testing = true;
            }
        }
    }

    public static class StartTestAbility
    extends Ability<EntitySculptor> {
        private static int MAX_RANGE_TO_GROUND = 12;
        private BlockPos spawnPillarPos;
        private BlockState spawnPillarBlock;
        private EntityPillar pillar;

        public StartTestAbility(AbilityType<EntitySculptor, StartTestAbility> abilityType, EntitySculptor user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 18), new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE)});
        }

        @Override
        public boolean tryAbility() {
            Vec3 to;
            Vec3 from = ((EntitySculptor)this.getUser()).m_20182_();
            BlockHitResult result = ((EntitySculptor)this.getUser()).f_19853_.m_45547_(new ClipContext(from, to = from.m_82492_(0.0, (double)MAX_RANGE_TO_GROUND, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.getUser()));
            if (result.m_6662_() != HitResult.Type.MISS) {
                BlockState blockAbove;
                this.spawnPillarPos = result.m_82425_();
                this.spawnPillarBlock = ((EntitySculptor)this.getUser()).f_19853_.m_8055_(this.spawnPillarPos);
                return result.m_82434_() == Direction.UP || !(blockAbove = ((EntitySculptor)this.getUser()).f_19853_.m_8055_(this.spawnPillarPos.m_7494_())).m_60828_((BlockGetter)((EntitySculptor)this.getUser()).f_19853_, this.spawnPillarPos.m_7494_()) && !blockAbove.m_60795_();
            }
            return false;
        }

        @Override
        public void start() {
            super.start();
            this.playAnimation("testStart", false);
            ((EntitySculptor)this.getUser()).testing = true;
            ((EntitySculptor)this.getUser()).testingPlayer = ((EntitySculptor)this.getUser()).getCustomer();
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE && this.spawnPillarPos != null) {
                if (this.spawnPillarBlock == null || !EffectGeomancy.isBlockDiggable(this.spawnPillarBlock)) {
                    this.spawnPillarBlock = Blocks.f_50069_.m_49966_();
                }
                this.pillar = new EntityPillar((EntityType<? extends EntityPillar>)((EntityType)EntityHandler.PILLAR.get()), ((EntitySculptor)this.getUser()).f_19853_, (LivingEntity)this.getUser(), Blocks.f_50069_.m_49966_(), this.spawnPillarPos);
                this.pillar.setTier(EntityGeomancyBase.GeomancyTier.SMALL);
                this.pillar.m_6034_((float)this.spawnPillarPos.m_123341_() + 0.5f, this.spawnPillarPos.m_123342_() + 1, (float)this.spawnPillarPos.m_123343_() + 0.5f);
                this.pillar.setDoRemoveTimer(false);
                if (this.pillar.checkCanSpawn()) {
                    ((EntitySculptor)this.getUser()).f_19853_.m_7967_((Entity)this.pillar);
                }
                ((EntitySculptor)this.getUser()).pillar = this.pillar;
                int numStartBoulders = this.rand.nextInt(2, 4);
                for (int i = 0; i < numStartBoulders; ++i) {
                    Vec3 spawnBoulderPos = this.pillar.m_20182_().m_82549_(new Vec3((double)this.rand.nextFloat(5.0f, 10.0f), 0.0, 0.0).m_82524_(this.rand.nextFloat((float)Math.PI * 2)));
                    EntityBoulderPlatform boulderPlatform = new EntityBoulderPlatform((EntityType<? extends EntityBoulderBase>)((EntityType)EntityHandler.BOULDER_PLATFORM.get()), ((EntitySculptor)this.getUser()).m_183503_(), (LivingEntity)this.getUser(), Blocks.f_50069_.m_49966_(), BlockPos.f_121853_, EntityGeomancyBase.GeomancyTier.MEDIUM);
                    boulderPlatform.m_146884_(spawnBoulderPos.m_82520_(0.0, 1.0, 0.0));
                    boulderPlatform.setMainPath();
                    ((EntitySculptor)this.getUser()).m_183503_().m_7967_((Entity)boulderPlatform);
                }
            }
        }

        @Override
        public void tick() {
            super.tick();
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE && this.pillar != null && this.pillar.getHeight() > (float)TEST_HEIGHT) {
                this.nextSection();
            }
        }

        @Override
        public void end() {
            super.end();
            if (this.pillar != null) {
                this.pillar.stopRising();
            }
        }
    }
}

