/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.client.model.LayerHandler;
import com.bobmowzie.mowziesmobs.client.model.armor.BarakoaMaskModel;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoayaToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.MowzieArmorItem;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;

public class ItemBarakoaMask
extends MowzieArmorItem
implements BarakoaMask {
    private final MaskType type;
    private static final BarakoaMaskMaterial BARAKOA_MASK_MATERIAL = new BarakoaMaskMaterial();

    public ItemBarakoaMask(MaskType type, Item.Properties properties) {
        super(BARAKOA_MASK_MATERIAL, EquipmentSlot.HEAD, properties);
        this.type = type;
    }

    public MobEffect getPotion() {
        return this.type.potion;
    }

    public boolean m_6832_(ItemStack itemStack, ItemStack materialItemStack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack headStack = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (headStack.m_41720_() instanceof ItemBarakoMask) {
            boolean didSpawn;
            if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SOL_VISAGE.breakable.get()).booleanValue() && !player.m_7500_()) {
                headStack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            if (didSpawn = this.spawnBarakoa(this.type, stack, player, (float)stack.m_41773_() / (float)stack.m_41776_())) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    private boolean spawnBarakoa(MaskType mask, ItemStack stack, Player player, float durability) {
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null && playerCapability.getPackSize() < 10) {
            player.m_5496_((SoundEvent)MMSounds.ENTITY_BARAKO_BELLY.get(), 1.5f, 1.0f);
            player.m_5496_((SoundEvent)MMSounds.ENTITY_BARAKOA_BLOWDART.get(), 1.5f, 0.5f);
            double angle = player.m_6080_();
            if (angle < 0.0) {
                angle += 360.0;
            }
            EntityBarakoanToPlayer barakoa = mask == MaskType.FAITH ? new EntityBarakoayaToPlayer((EntityType<? extends EntityBarakoayaToPlayer>)((EntityType)EntityHandler.BARAKOAYA_TO_PLAYER.get()), player.f_19853_, player) : new EntityBarakoanToPlayer((EntityType<? extends EntityBarakoanToPlayer>)((EntityType)EntityHandler.BARAKOAN_TO_PLAYER.get()), player.f_19853_, player);
            if (!player.f_19853_.f_46443_) {
                if (mask != MaskType.FAITH) {
                    int weapon = mask != MaskType.FURY ? barakoa.randomizeWeapon() : 0;
                    barakoa.setWeapon(weapon);
                }
                barakoa.m_19890_(player.m_20185_() + 1.0 * Math.sin(-angle * (Math.PI / 180)), player.m_20186_() + 1.5, player.m_20189_() + 1.0 * Math.cos(-angle * (Math.PI / 180)), (float)angle, 0.0f);
                barakoa.setActive(false);
                barakoa.active = false;
                player.f_19853_.m_7967_((Entity)barakoa);
                double vx = 0.5 * Math.sin(-angle * Math.PI / 180.0);
                double vy = 0.5;
                double vz = 0.5 * Math.cos(-angle * Math.PI / 180.0);
                barakoa.m_20334_(vx, vy, vz);
                barakoa.m_21153_((1.0f - durability) * barakoa.m_21233_());
                barakoa.setMask(mask);
                barakoa.setStoredMask(stack.m_41777_());
                if (stack.m_41788_()) {
                    barakoa.m_6593_(stack.m_41786_());
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String s = ChatFormatting.m_126649_((String)stack.m_41786_().getString());
        boolean wadoo = stack.m_41788_() && s != null && s.equals("Wadoo");
        return new ResourceLocation("mowziesmobs", "textures/entity/barakoa_" + this.type.name + (wadoo ? "_wadoo" : "") + ".png").toString();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".text.0").m_6270_(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".text.1").m_6270_(ItemHandler.TOOLTIP_STYLE));
    }

    @Override
    public ConfigHandler.ArmorConfig getConfig() {
        return ConfigHandler.COMMON.TOOLS_AND_ABILITIES.BARAKOA_MASK.armorConfig;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(ArmorRender.INSTANCE);
    }

    private static class BarakoaMaskMaterial
    implements ArmorMaterial {
        private BarakoaMaskMaterial() {
        }

        public int m_7366_(EquipmentSlot equipmentSlotType) {
            return ArmorMaterials.LEATHER.m_7366_(equipmentSlotType);
        }

        public int m_7365_(EquipmentSlot equipmentSlotType) {
            return (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.BARAKOA_MASK.armorConfig.damageReduction.get();
        }

        public int m_6646_() {
            return ArmorMaterials.LEATHER.m_6646_();
        }

        public SoundEvent m_7344_() {
            return ArmorMaterials.LEATHER.m_7344_();
        }

        public Ingredient m_6230_() {
            return null;
        }

        public String m_6082_() {
            return "barakoa_mask";
        }

        public float m_6651_() {
            return ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.BARAKOA_MASK.armorConfig.toughness.get()).floatValue();
        }

        public float m_6649_() {
            return ArmorMaterials.LEATHER.m_6649_();
        }
    }

    private static final class ArmorRender
    implements IItemRenderProperties {
        private static final ArmorRender INSTANCE = new ArmorRender();
        private static HumanoidModel<?> MODEL;

        private ArmorRender() {
        }

        public HumanoidModel<?> getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
            if (MODEL == null) {
                EntityModelSet models = Minecraft.m_91087_().m_167973_();
                ModelPart root = models.m_171103_(LayerHandler.BARAKOA_MASK_LAYER);
                MODEL = new BarakoaMaskModel(root);
            }
            return MODEL;
        }
    }
}

