/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.ConfiguredFeatureHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.BarakoaVillagePieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MowzieStructure;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class BarakoaVillageStructure
extends MowzieStructure {
    public BarakoaVillageStructure(Codec<NoneFeatureConfiguration> codec) {
        super(codec, ConfigHandler.COMMON.MOBS.BARAKO.generationConfig, ConfiguredFeatureHandler.BARAKO_BIOMES, (PieceGenerator<NoneFeatureConfiguration>)((PieceGenerator)BarakoaVillageStructure::generatePieces));
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> pieceGenerator) {
        int angle;
        Rotation rotation = Rotation.values()[pieceGenerator.f_192708_().nextInt(Rotation.values().length)];
        int x = (pieceGenerator.f_192705_().f_45578_ << 4) + 7;
        int z = (pieceGenerator.f_192705_().f_45579_ << 4) + 7;
        BlockPos centerPos = new BlockPos(x, 1, z);
        ChunkGenerator generator = pieceGenerator.f_192703_();
        LevelHeightAccessor heightLimitView = pieceGenerator.f_192707_();
        WorldgenRandom random = pieceGenerator.f_192708_();
        int surfaceY = generator.m_142647_(centerPos.m_123341_(), centerPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        int oceanFloorY = generator.m_142647_(centerPos.m_123341_(), centerPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView);
        if (oceanFloorY < surfaceY) {
            return;
        }
        builder.m_142679_((StructurePiece)new BarakoaVillagePieces.FirepitPiece((Random)random, x - 4, z - 4));
        BlockPos offset = new BlockPos(0, 0, 9);
        offset = offset.m_7954_(rotation);
        BlockPos thronePos = BarakoaVillageStructure.posToSurface(generator, centerPos.m_141952_((Vec3i)offset), heightLimitView);
        BarakoaVillagePieces.addPiece(BarakoaVillagePieces.THRONE, pieceGenerator.f_192704_(), thronePos, rotation, (StructurePieceAccessor)builder, pieceGenerator.f_192708_());
        int numHouses = random.nextInt(4) + 3;
        block0: for (int i = 1; i <= numHouses; ++i) {
            for (int j = 0; j < 30; ++j) {
                float distance = random.nextInt(8) + 10;
                angle = random.nextInt(360);
                BlockPos housePos = new BlockPos((double)centerPos.m_123341_() + (double)distance * Math.sin(Math.toRadians(angle)), 0.0, (double)centerPos.m_123343_() + (double)distance * Math.cos(Math.toRadians(angle)));
                housePos = BarakoaVillageStructure.posToSurface(generator, housePos, heightLimitView);
                housePos = housePos.m_5484_(Direction.UP, random.nextInt(2));
                if (BarakoaVillageStructure.startHouse(generator, pieceGenerator.f_192704_(), builder, housePos, pieceGenerator.f_192708_())) continue block0;
            }
        }
        int numAltars = random.nextInt(3) + 2;
        block2: for (int i = 1; i <= numAltars; ++i) {
            for (int j = 1; j <= 10; ++j) {
                int distance = random.nextInt(15) + 5;
                angle = random.nextInt(360);
                BlockPos altarPos = new BlockPos((double)centerPos.m_123341_() + (double)distance * Math.sin(Math.toRadians(angle)), 0.0, (double)centerPos.m_123343_() + (double)distance * Math.cos(Math.toRadians(angle)));
                BarakoaVillagePieces.AltarPiece altar = new BarakoaVillagePieces.AltarPiece((altarPos = BarakoaVillageStructure.posToSurface(generator, altarPos, heightLimitView)).m_123341_(), altarPos.m_123342_(), altarPos.m_123343_(), Direction.NORTH);
                if (builder.m_141921_(altar.m_73547_()) != null) continue;
                builder.m_142679_((StructurePiece)altar);
                continue block2;
            }
        }
        int numStakes = random.nextInt(12) + 5;
        block4: for (int i = 1; i <= numStakes; ++i) {
            for (int j = 1; j <= 10; ++j) {
                int distance = random.nextInt(15) + 5;
                int angle2 = random.nextInt(360);
                BlockPos stakePos = new BlockPos((double)centerPos.m_123341_() + (double)distance * Math.sin(Math.toRadians(angle2)), 0.0, (double)centerPos.m_123343_() + (double)distance * Math.cos(Math.toRadians(angle2)));
                BarakoaVillagePieces.StakePiece stake = new BarakoaVillagePieces.StakePiece((Random)random, (stakePos = BarakoaVillageStructure.posToSurface(generator, stakePos, heightLimitView)).m_123341_(), stakePos.m_123342_(), stakePos.m_123343_());
                if (builder.m_141921_(stake.m_73547_()) != null) continue;
                builder.m_142679_((StructurePiece)stake);
                continue block4;
            }
        }
    }

    private static boolean startHouse(ChunkGenerator generator, StructureManager templateManagerIn, StructurePiecesBuilder builder, BlockPos housePos, WorldgenRandom random) {
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        StructurePiece newHouse = BarakoaVillagePieces.addHouse(templateManagerIn, housePos, rotation, builder, random);
        if (newHouse != null) {
            Rotation roofRotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            StructurePiece roof = BarakoaVillagePieces.addPiece(BarakoaVillagePieces.ROOF, templateManagerIn, housePos, roofRotation, (StructurePieceAccessor)builder, random);
            int sideHouseDir = random.nextInt(6) + 1;
            if (sideHouseDir <= 2) {
                Rotation sideHouseRotation;
                Rotation rotation2 = sideHouseRotation = sideHouseDir == 1 ? rotation.m_55952_(Rotation.CLOCKWISE_90) : rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90);
                if (BarakoaVillagePieces.addPieceCheckBounds(BarakoaVillagePieces.HOUSE_SIDE, templateManagerIn, housePos, sideHouseRotation, (StructurePieceAccessor)builder, random, Arrays.asList(newHouse, roof)) == null) {
                    sideHouseRotation = sideHouseRotation.m_55952_(Rotation.CLOCKWISE_180);
                    BarakoaVillagePieces.addPieceCheckBounds(BarakoaVillagePieces.HOUSE_SIDE, templateManagerIn, housePos, sideHouseRotation, (StructurePieceAccessor)builder, random, Arrays.asList(newHouse, roof));
                }
            }
            return true;
        }
        return false;
    }

    private static BlockPos posToSurface(ChunkGenerator generator, BlockPos pos, LevelHeightAccessor heightAccessor) {
        int surfaceY = generator.m_142647_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
        return new BlockPos(pos.m_123341_(), surfaceY - 1, pos.m_123343_());
    }
}

