/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.server.animation;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import com.ilexiconn.llibrary.server.event.AnimationEvent;
import com.ilexiconn.llibrary.server.network.AnimationMessage;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public enum AnimationHandler {
    INSTANCE;


    public <T extends Entity> void sendAnimationMessage(T entity, Animation animation) {
        if (entity.f_19853_.f_46443_) {
            return;
        }
        ((IAnimatedEntity)entity).setAnimation(animation);
        MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new AnimationMessage(entity.m_142049_(), ArrayUtils.indexOf((Object[])((IAnimatedEntity)entity).getAnimations(), (Object)animation)));
    }

    public <T extends Entity> void updateAnimations(T entity) {
        if (((IAnimatedEntity)entity).getAnimation() == null) {
            ((IAnimatedEntity)entity).setAnimation(IAnimatedEntity.NO_ANIMATION);
        } else if (((IAnimatedEntity)entity).getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            AnimationEvent.Start<T> event;
            if (((IAnimatedEntity)entity).getAnimationTick() == 0 && !MinecraftForge.EVENT_BUS.post(event = new AnimationEvent.Start<T>(entity, ((IAnimatedEntity)entity).getAnimation()))) {
                this.sendAnimationMessage(entity, event.getAnimation());
            }
            if (((IAnimatedEntity)entity).getAnimationTick() < ((IAnimatedEntity)entity).getAnimation().getDuration()) {
                ((IAnimatedEntity)entity).setAnimationTick(((IAnimatedEntity)entity).getAnimationTick() + 1);
                MinecraftForge.EVENT_BUS.post(new AnimationEvent.Tick<T>(entity, ((IAnimatedEntity)entity).getAnimation(), ((IAnimatedEntity)entity).getAnimationTick()));
            }
            if (((IAnimatedEntity)entity).getAnimationTick() == ((IAnimatedEntity)entity).getAnimation().getDuration()) {
                if (!((IAnimatedEntity)entity).getAnimation().doesLoop()) {
                    ((IAnimatedEntity)entity).setAnimation(IAnimatedEntity.NO_ANIMATION);
                }
                ((IAnimatedEntity)entity).setAnimationTick(0);
            }
        }
    }
}

