/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.client.screen.modules;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.client.screen.BookScreen;
import com.obscuria.obscureapi.client.screen.modules.BookModule;
import com.obscuria.obscureapi.client.screen.widgets.ObscureTooltip;
import com.obscuria.obscureapi.client.screen.widgets.ObscureWidget;
import com.obscuria.obscureapi.registry.ObscureAPISounds;
import com.obscuria.obscureapi.utils.ScreenHelper;
import com.obscuria.obscureapi.utils.TextHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AboutModule
implements BookModule {
    public final List<ObscureWidget> WIDGETS = new ArrayList<ObscureWidget>();

    @Override
    public void tick(BookScreen screen) {
        this.WIDGETS.forEach(ObscureWidget::tick);
    }

    @Override
    public void init(BookScreen screen) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)ObscureAPISounds.OBSCURE_BOOK_MIRACLE.get()), (float)1.0f, (float)1.0f));
        this.WIDGETS.clear();
        this.WIDGETS.add(this.social(screen, -103, 26, 30, "discord", "https://discord.gg/jSHHJSUWdY"));
        this.WIDGETS.add(this.social(screen, -86, 43, 0, "curseforge", "https://www.curseforge.com/members/obscuriaofficial/projects"));
        this.WIDGETS.add(this.social(screen, -69, 26, 0, "patreon", "https://www.patreon.com/Obscuria"));
        this.WIDGETS.add(this.social(screen, -52, 43, 90, "github", "https://github.com/ObscuriaLithium"));
        this.WIDGETS.add(this.social(screen, -35, 26, 60, "planet", "https://www.planetminecraft.com/member/obscuria"));
        int offsetX = 0;
        int offsetY = 0;
        boolean offset = false;
        for (Map.Entry<String, String> entry : ObscureAPI.COLLECTION_MODS.entrySet()) {
            this.WIDGETS.add(this.mod(screen, (offset ? 39 : 27) + 24 * offsetX, -57 + 12 * offsetY, entry.getKey(), entry.getValue()));
            if (++offsetX < 4) continue;
            offsetX = 0;
            ++offsetY;
            offset = !offset;
        }
    }

    private ObscureWidget mod(BookScreen screen, int x, int y, final String id, String slug) {
        return new ObscureWidget(false, screen, x, y, 22, 22, button -> Util.m_137581_().m_137646_("https://www.curseforge.com/minecraft/mc-mods/" + slug), new ObscureTooltip(){

            @Override
            public List<Component> getTooltip(ObscureWidget widget, Screen screen) {
                boolean license = ModList.get().getModFileById(id).getLicense().length() == 47 && ModList.get().getModFileById(id).getLicense().startsWith("Obscuria Lithium (c) 20") && ModList.get().getModFileById(id).getLicense().endsWith("All Rights Reserved.");
                return TextHelper.build(new ArrayList<Component>(), "f", "7", TextHelper.translatableComponent("obscure_book.mod_template").getString().replace("{NAME}", (ModList.get().getModContainerById(id).isPresent() ? ((ModContainer)ModList.get().getModContainerById(id).get()).getModInfo().getDisplayName() : "Mod ID not present") + (license ? "" : "\u00a7c Unofficial Mod")).replace("{DESCRIPTION}", TextHelper.translatableComponent("obscure_book." + id + ".description").getString()).replace("{ID}", id).replace("{VERSION}", ModList.get().getModFileById(id).versionString()));
            }
        }){

            @Override
            public void m_6303_(@NotNull PoseStack pose, int mouseX, int mouseY, float partialTicks) {
                ScreenHelper.start();
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(id, "textures/gui/obscure_book/" + id + "_icon.png"));
                GuiComponent.m_93133_((PoseStack)pose, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)(this.f_93622_ ? 22.0f : 0.0f), (int)22, (int)22, (int)22, (int)44);
                ScreenHelper.end();
            }
        };
    }

    private ObscureWidget social(BookScreen screen, int x, int y, final int offset, final String name, String link) {
        return new ObscureWidget(false, screen, x, y, 30, 30, button -> Util.m_137581_().m_137646_(link), new ObscureTooltip(){

            @Override
            public List<Component> getTooltip(ObscureWidget widget, Screen screen) {
                return TextHelper.build(new ArrayList<Component>(), "f", "7", TextHelper.translatableComponent("obscure_book.module_about." + name).getString());
            }
        }){
            int animation;
            {
                super(square, screen, x, y, width, height, action, tooltip);
                this.animation = 1;
            }

            @Override
            public void tick() {
                ++this.animation;
                if (this.animation == 31) {
                    this.animation = 1;
                }
            }

            @Override
            public void m_6303_(@NotNull PoseStack pose, int mouseX, int mouseY, float partialTicks) {
                ScreenHelper.start();
                if (name.equals("patreon")) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("obscure_api:textures/gui/patreon/" + this.animation + ".png"));
                    GuiComponent.m_93133_((PoseStack)pose, (int)this.f_93620_, (int)this.f_93621_, (float)offset, (float)(this.f_93622_ ? 30.0f : 0.0f), (int)30, (int)30, (int)30, (int)60);
                } else {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("obscure_api:textures/gui/obscure_book/module_about.png"));
                    GuiComponent.m_93133_((PoseStack)pose, (int)this.f_93620_, (int)this.f_93621_, (float)offset, (float)(this.f_93622_ ? 222.0f : 192.0f), (int)30, (int)30, (int)512, (int)256);
                }
                ScreenHelper.end();
            }
        };
    }

    @Override
    public void render(BookScreen screen, PoseStack pose, int mouseX, int mouseY) {
        ScreenHelper.start();
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("obscure_api:textures/gui/obscure_book/module_about.png"));
        GuiComponent.m_93133_((PoseStack)pose, (int)-145, (int)-96, (float)0.0f, (float)0.0f, (int)290, (int)192, (int)512, (int)256);
        ScreenHelper.end();
        screen.getMinecraft().f_91062_.m_92889_(pose, (Component)TextHelper.translatableComponent("obscure_book.module_about.name"), -123.0f, -82.0f, 0);
        pose.m_85836_();
        pose.m_85837_(-120.0, -70.0, 0.0);
        pose.m_85841_(ScreenHelper.scale(), ScreenHelper.scale(), 1.0f);
        ScreenHelper.drawText(TextHelper.build(new ArrayList<Component>(), "0", "0", TextHelper.translatableComponent("obscure_book.module_about.content").getString()), screen.getMinecraft().f_91062_, pose);
        pose.m_85849_();
        screen.getMinecraft().f_91062_.m_92889_(pose, (Component)TextHelper.translatableComponent("obscure_book.module_about.mods"), 15.0f, -82.0f, 0);
        pose.m_85836_();
        pose.m_85837_(18.0, 45.0, 0.0);
        pose.m_85841_(ScreenHelper.scale(), ScreenHelper.scale(), 1.0f);
        ScreenHelper.drawText(TextHelper.build(new ArrayList<Component>(), "0", "0", TextHelper.translatableComponent("obscure_book.module_about.mod_list").getString()), screen.getMinecraft().f_91062_, pose);
        pose.m_85849_();
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("obscure_api", "textures/gui/obscure_book/icon_about.png");
    }

    @Override
    public String getModuleName() {
        return "about";
    }

    @Override
    public List<ObscureWidget> getWidgets() {
        return this.WIDGETS;
    }
}

