/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.world.classes;

import com.obscuria.obscureapi.registry.ObscureAPIMobEffects;
import com.obscuria.obscureapi.utils.TextHelper;
import com.obscuria.obscureapi.world.classes.IBonusItem;
import com.obscuria.obscureapi.world.classes.IClassItem;
import com.obscuria.obscureapi.world.classes.ObscureBonus;
import com.obscuria.obscureapi.world.classes.ObscureClass;
import com.obscuria.obscureapi.world.classes.ObscureType;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;

public class ObscureAbility {
    public final Item ITEM;
    public final String TEXT;
    public final Cost COST_TYPE;
    public final int COST;
    public final int[] VALUES;

    public ObscureAbility(Item item, String text) {
        this(item, text, Cost.NONE, 0);
    }

    public ObscureAbility(Item item, String text, Cost costType, int cost) {
        this(item, text, costType, cost, 0, 0, 0);
    }

    public ObscureAbility(Item item, String text, Cost costType, int cost, int i1) {
        this(item, text, costType, cost, i1, 0, 0);
    }

    public ObscureAbility(Item item, String text, Cost costType, int cost, int i1, int i2) {
        this(item, text, costType, cost, i1, i2, 0);
    }

    public ObscureAbility(Item item, String text, Cost costType, int cost, int i1, int i2, int i3) {
        this.ITEM = item;
        this.TEXT = text;
        this.COST_TYPE = costType;
        this.COST = cost;
        this.VALUES = new int[]{i1, i2, i3};
    }

    public int getCost(LivingEntity entity) {
        Item item;
        if (entity == null || this.COST_TYPE == Cost.NONE) {
            return 0;
        }
        int mod1 = 0;
        int mod2 = 0;
        if (this.COST_TYPE == Cost.COOLDOWN && entity.m_21023_((MobEffect)ObscureAPIMobEffects.RUSH.get())) {
            mod2 += -10 - 10 * Objects.requireNonNull(entity.m_21124_((MobEffect)ObscureAPIMobEffects.RUSH.get())).m_19564_();
        }
        if ((item = this.ITEM) instanceof IClassItem) {
            IBonusItem item2;
            List<ObscureBonus> list;
            List<ObscureBonus> list2;
            List<ObscureBonus> list3;
            List<ObscureBonus> list4;
            IClassItem classItem = (IClassItem)item;
            ObscureClass obscureClass = classItem.getObscureClass();
            ObscureType obscureType = classItem.getObscureType();
            Item item3 = entity.m_6844_(EquipmentSlot.HEAD).m_41720_();
            if (item3 instanceof IBonusItem) {
                IBonusItem item4 = (IBonusItem)item3;
                list4 = item4.getObscureBonuses();
            } else {
                list4 = null;
            }
            List<ObscureBonus> ARMOR_HEAD = list4;
            Item item5 = entity.m_6844_(EquipmentSlot.CHEST).m_41720_();
            if (item5 instanceof IBonusItem) {
                IBonusItem item6 = (IBonusItem)item5;
                list3 = item6.getObscureBonuses();
            } else {
                list3 = null;
            }
            List<ObscureBonus> ARMOR_CHEST = list3;
            Item item7 = entity.m_6844_(EquipmentSlot.LEGS).m_41720_();
            if (item7 instanceof IBonusItem) {
                IBonusItem item8 = (IBonusItem)item7;
                list2 = item8.getObscureBonuses();
            } else {
                list2 = null;
            }
            List<ObscureBonus> ARMOR_LEGS = list2;
            Item item9 = entity.m_6844_(EquipmentSlot.FEET).m_41720_();
            if (item9 instanceof IBonusItem) {
                IBonusItem item10 = (IBonusItem)item9;
                list = item10.getObscureBonuses();
            } else {
                list = null;
            }
            List<ObscureBonus> ARMOR_FEET = list;
            Item item11 = entity.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            List<ObscureBonus> HAND = item11 instanceof IBonusItem && !((item2 = (IBonusItem)item11) instanceof ArmorItem) ? item2.getObscureBonuses() : null;
            mod1 += this.getBonus(ARMOR_HEAD, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.AMOUNT) + this.getBonus(ARMOR_CHEST, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.AMOUNT) + this.getBonus(ARMOR_LEGS, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.AMOUNT) + this.getBonus(ARMOR_FEET, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.AMOUNT) + this.getBonus(HAND, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.AMOUNT);
            mod2 += this.getBonus(ARMOR_HEAD, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.PERCENT) + this.getBonus(ARMOR_CHEST, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.PERCENT) + this.getBonus(ARMOR_LEGS, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.PERCENT) + this.getBonus(ARMOR_FEET, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.PERCENT) + this.getBonus(HAND, obscureClass, obscureType, this.COST_TYPE.toBonus(), ObscureBonus.Operation.PERCENT);
        }
        mod2 = Math.max(mod2, -80);
        return (int)Math.max((double)Math.round((double)(this.COST + mod1) + (double)this.COST * ((double)mod2 / 100.0)), 1.0);
    }

    public int getAmount(LivingEntity entity, int index) {
        Item item;
        if (entity == null) {
            return 0;
        }
        int amount = this.VALUES[index];
        if (amount <= 0) {
            return 0;
        }
        int mod1 = 0;
        int mod2 = 0;
        if (entity.m_21023_((MobEffect)ObscureAPIMobEffects.FURY.get())) {
            mod2 += 10 + 10 * Objects.requireNonNull(entity.m_21124_((MobEffect)ObscureAPIMobEffects.FURY.get())).m_19564_();
        }
        if ((item = this.ITEM) instanceof IClassItem) {
            IBonusItem item2;
            List<ObscureBonus> list;
            List<ObscureBonus> list2;
            List<ObscureBonus> list3;
            List<ObscureBonus> list4;
            IClassItem classItem = (IClassItem)item;
            ObscureClass obscureClass = classItem.getObscureClass();
            ObscureType obscureType = classItem.getObscureType();
            Item item3 = entity.m_6844_(EquipmentSlot.HEAD).m_41720_();
            if (item3 instanceof IBonusItem) {
                IBonusItem item4 = (IBonusItem)item3;
                list4 = item4.getObscureBonuses();
            } else {
                list4 = null;
            }
            List<ObscureBonus> ARMOR_HEAD = list4;
            Item item5 = entity.m_6844_(EquipmentSlot.CHEST).m_41720_();
            if (item5 instanceof IBonusItem) {
                IBonusItem item6 = (IBonusItem)item5;
                list3 = item6.getObscureBonuses();
            } else {
                list3 = null;
            }
            List<ObscureBonus> ARMOR_CHEST = list3;
            Item item7 = entity.m_6844_(EquipmentSlot.LEGS).m_41720_();
            if (item7 instanceof IBonusItem) {
                IBonusItem item8 = (IBonusItem)item7;
                list2 = item8.getObscureBonuses();
            } else {
                list2 = null;
            }
            List<ObscureBonus> ARMOR_LEGS = list2;
            Item item9 = entity.m_6844_(EquipmentSlot.FEET).m_41720_();
            if (item9 instanceof IBonusItem) {
                IBonusItem item10 = (IBonusItem)item9;
                list = item10.getObscureBonuses();
            } else {
                list = null;
            }
            List<ObscureBonus> ARMOR_FEET = list;
            Item item11 = entity.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            List<ObscureBonus> HAND = item11 instanceof IBonusItem && !((item2 = (IBonusItem)item11) instanceof ArmorItem) ? item2.getObscureBonuses() : null;
            mod1 += this.getBonus(ARMOR_HEAD, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.AMOUNT) + this.getBonus(ARMOR_CHEST, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.AMOUNT) + this.getBonus(ARMOR_LEGS, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.AMOUNT) + this.getBonus(ARMOR_FEET, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.AMOUNT) + this.getBonus(HAND, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.AMOUNT);
            mod2 += this.getBonus(ARMOR_HEAD, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.PERCENT) + this.getBonus(ARMOR_CHEST, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.PERCENT) + this.getBonus(ARMOR_LEGS, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.PERCENT) + this.getBonus(ARMOR_FEET, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.PERCENT) + this.getBonus(HAND, obscureClass, obscureType, ObscureBonus.Type.POWER, ObscureBonus.Operation.PERCENT);
        }
        return (int)Math.max((double)Math.round((double)(amount + mod1) + (double)amount * ((double)mod2 / 100.0)), 1.0);
    }

    public String getCostString(LivingEntity entity) {
        int cost = this.COST;
        int modCost = this.getCost(entity);
        String costString = TextHelper.translation("ability.cost." + this.COST_TYPE.getName());
        String costAmount = cost < modCost ? "\u00a7c" + modCost : (cost > modCost ? "\u00a72" + modCost : Integer.valueOf(modCost));
        costString = costString.replace("#", costAmount);
        return " " + costString + (String)(cost < modCost ? " \u00a78+" + Math.round(((double)modCost / 1.0 / (double)cost - 1.0) * 100.0) + "%" : (cost > modCost ? " \u00a78-" + Math.round((1.0 - (double)modCost / 1.0 / (double)cost) * 100.0) + "%" : ""));
    }

    public String getAmountString(LivingEntity entity, int index) {
        int amount = this.VALUES[index];
        int modAmount = this.getAmount(entity, index);
        return "" + (Serializable)(amount < modAmount ? "\u00a72" + modAmount : (amount > modAmount ? "\u00a7c" + modAmount : Integer.valueOf(modAmount)));
    }

    private int getBonus(List<ObscureBonus> bonuses, ObscureClass obscureClass, ObscureType obscureType, ObscureBonus.Type bonus, ObscureBonus.Operation operation) {
        int mod2 = 0;
        if (bonuses != null && !bonuses.isEmpty()) {
            for (ObscureBonus entry : bonuses) {
                if (!entry.CLASS.equals(obscureClass) || !entry.TYPE.equals(obscureType) || !entry.BONUS.equals((Object)bonus) || !entry.OPERATION.equals((Object)operation)) continue;
                mod2 += entry.AMOUNT;
            }
        }
        return mod2;
    }

    public static enum Cost {
        NONE("none"),
        COOLDOWN("cooldown"),
        XP("xp"),
        DURABILITY("durability");

        private final String NAME;

        private Cost(String name) {
            this.NAME = name;
        }

        public String getName() {
            return this.NAME;
        }

        public ObscureBonus.Type toBonus() {
            if (this.NAME.equals("cooldown")) {
                return ObscureBonus.Type.COOLDOWN;
            }
            return ObscureBonus.Type.POWER;
        }
    }
}

