/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.world.classes;

import com.obscuria.obscureapi.utils.TextHelper;
import com.obscuria.obscureapi.world.classes.IClassItem;
import com.obscuria.obscureapi.world.classes.ObscureClass;
import com.obscuria.obscureapi.world.classes.ObscureType;
import net.minecraft.world.item.Item;

public class ObscureBonus {
    public final ObscureClass CLASS;
    public final ObscureType TYPE;
    public final Type BONUS;
    public final Operation OPERATION;
    public final int AMOUNT;

    public ObscureBonus(ObscureClass itemClass, ObscureType itemType, Type type, Operation operation, int amount) {
        this.CLASS = itemClass;
        this.TYPE = itemType;
        this.BONUS = type;
        this.OPERATION = operation;
        this.AMOUNT = amount;
    }

    public String getBonusString() {
        return TextHelper.translation("class_bonus." + this.TYPE.getName() + "_" + this.BONUS.getName() + "." + (this.AMOUNT >= 0 ? "plus" : "minus")).replace("#1", this.AMOUNT + this.OPERATION.getName()).replace("#2", this.CLASS.getName());
    }

    public boolean canBeApplied(Item item) {
        IClassItem classItem;
        return item instanceof IClassItem && (classItem = (IClassItem)item).getObscureClass().equals(this.CLASS) && classItem.getObscureType().equals(this.TYPE);
    }

    public static enum Type {
        POWER("power"),
        COOLDOWN("cooldown");

        private final String NAME;

        private Type(String name) {
            this.NAME = name;
        }

        public String getName() {
            return this.NAME;
        }
    }

    public static enum Operation {
        AMOUNT(""),
        PERCENT("%");

        private final String NAME;

        private Operation(String name) {
            this.NAME = name;
        }

        public String getName() {
            return this.NAME;
        }
    }
}

