/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.particles.circle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.init.ParticleRegistry;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class CircleTintData
implements ParticleOptions {
    private final Color tint;
    private final float diameter;
    private final int lifeTime;
    private final float resizeSpeed;
    private final boolean shouldCollide;
    public static final Codec<CircleTintData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tint").forGetter(d -> d.tint.getRGB()), (App)Codec.FLOAT.fieldOf("diameter").forGetter(d -> Float.valueOf(d.diameter)), (App)Codec.INT.fieldOf("life_time").forGetter(d -> d.lifeTime), (App)Codec.FLOAT.fieldOf("resize_speed").forGetter(d -> Float.valueOf(d.resizeSpeed)), (App)Codec.BOOL.fieldOf("should_collide").forGetter(d -> d.shouldCollide)).apply((Applicative)instance, CircleTintData::new));
    public static final ParticleOptions.Deserializer<CircleTintData> DESERIALIZER = new ParticleOptions.Deserializer<CircleTintData>(){

        @Nonnull
        public CircleTintData fromCommand(@Nonnull ParticleType<CircleTintData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int red = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            float diameter = CircleTintData.validateDiameter(reader.readFloat());
            reader.expect(' ');
            int lifeTime = reader.readInt();
            reader.expect(' ');
            float resizeSpeed = reader.readFloat();
            reader.expect(' ');
            boolean shouldCollide = reader.readBoolean();
            return new CircleTintData(new Color(red, green, blue), diameter, lifeTime, resizeSpeed, shouldCollide);
        }

        public CircleTintData fromNetwork(@Nonnull ParticleType<CircleTintData> type, FriendlyByteBuf buf) {
            int red = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int green = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int blue = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue);
            float diameter = CircleTintData.validateDiameter(buf.readFloat());
            int lifeTime = buf.readInt();
            float resizeSpeed = buf.readFloat();
            boolean shouldCollide = buf.readBoolean();
            return new CircleTintData(color, diameter, lifeTime, resizeSpeed, shouldCollide);
        }
    };

    public CircleTintData(Color tint, float diameter, int lifeTime, float resizeSpeed, boolean shouldCollide) {
        this.tint = tint;
        this.lifeTime = lifeTime;
        this.diameter = CircleTintData.validateDiameter(diameter);
        this.resizeSpeed = resizeSpeed;
        this.shouldCollide = shouldCollide;
    }

    public Color getTint() {
        return this.tint;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public float getDiameter() {
        return this.diameter;
    }

    public float getResizeSpeed() {
        return this.resizeSpeed;
    }

    public boolean shouldCollide() {
        return this.shouldCollide;
    }

    @Nonnull
    public ParticleType<CircleTintData> m_6012_() {
        return ParticleRegistry.CIRCLE_TINT;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeFloat(this.diameter);
        buf.writeInt(this.lifeTime);
        buf.writeFloat(this.resizeSpeed);
        buf.writeBoolean(this.shouldCollide);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %i %i %i %.2f %i %f %b", this.m_6012_().getRegistryName(), this.tint.getRed(), this.tint.getGreen(), this.tint.getBlue(), Float.valueOf(this.diameter), this.lifeTime, Float.valueOf(this.resizeSpeed), this.shouldCollide);
    }

    private static float validateDiameter(float diameter) {
        return (float)Mth.m_14008_((double)diameter, (double)0.05, (double)5.0);
    }

    private CircleTintData(int tintRGB, float diameter, int lifeTime, float resizeSpeed, boolean shouldCollide) {
        this.tint = new Color(tintRGB);
        this.lifeTime = lifeTime;
        this.diameter = CircleTintData.validateDiameter(diameter);
        this.resizeSpeed = resizeSpeed;
        this.shouldCollide = shouldCollide;
    }
}

