/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.particles.spark;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.init.ParticleRegistry;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class SparkTintData
implements ParticleOptions {
    private final Color tint;
    private final float diameter;
    private final int lifeTime;
    public static final Codec<SparkTintData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tint").forGetter(d -> d.tint.getRGB()), (App)Codec.FLOAT.fieldOf("diameter").forGetter(d -> Float.valueOf(d.diameter)), (App)Codec.INT.fieldOf("life_time").forGetter(d -> d.lifeTime)).apply((Applicative)instance, SparkTintData::new));
    public static final ParticleOptions.Deserializer<SparkTintData> DESERIALIZER = new ParticleOptions.Deserializer<SparkTintData>(){

        @Nonnull
        public SparkTintData fromCommand(@Nonnull ParticleType<SparkTintData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int red = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            float diameter = SparkTintData.validateDiameter(reader.readFloat());
            reader.expect(' ');
            int lifeTime = reader.readInt();
            return new SparkTintData(new Color(red, green, blue), diameter, lifeTime);
        }

        public SparkTintData fromNetwork(@Nonnull ParticleType<SparkTintData> type, FriendlyByteBuf buf) {
            int red = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int green = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int blue = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue);
            float diameter = SparkTintData.validateDiameter(buf.readFloat());
            int lifeTime = buf.readInt();
            return new SparkTintData(color, diameter, lifeTime);
        }
    };

    public SparkTintData(Color tint, float diameter, int lifeTime) {
        this.tint = tint;
        this.lifeTime = lifeTime;
        this.diameter = SparkTintData.validateDiameter(diameter);
    }

    public Color getTint() {
        return this.tint;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public float getDiameter() {
        return this.diameter;
    }

    @Nonnull
    public ParticleType<SparkTintData> m_6012_() {
        return ParticleRegistry.SPARK_TINT;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeFloat(this.diameter);
        buf.writeInt(this.lifeTime);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %i %i %i %.2f %i", this.m_6012_().getRegistryName(), this.tint.getRed(), this.tint.getGreen(), this.tint.getBlue(), Float.valueOf(this.diameter), this.lifeTime);
    }

    private static float validateDiameter(float diameter) {
        return (float)Mth.m_14008_((double)diameter, (double)0.05, (double)5.0);
    }

    private SparkTintData(int tintRGB, float diameter, int lifeTime) {
        this.tint = new Color(tintRGB);
        this.lifeTime = lifeTime;
        this.diameter = SparkTintData.validateDiameter(diameter);
    }
}

