/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityRerollButtonWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityResetButtonWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.AbilityUpgradeButtonWidget;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbilityDescriptionScreen
extends Screen {
    private final Minecraft MC = Minecraft.m_91087_();
    public static final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/gui/description/ability_background.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("relics", "textures/gui/description/relic_widgets.png");
    public final BlockPos pos;
    public ItemStack stack;
    public final String ability;
    public int backgroundHeight = 177;
    public int backgroundWidth = 256;

    public AbilityDescriptionScreen(BlockPos pos, ItemStack stack, String ability) {
        super(TextComponent.f_131282_);
        this.pos = pos;
        this.stack = stack;
        this.ability = ability;
    }

    protected void m_7856_() {
        Item item = this.stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return;
        }
        RelicItem relic = (RelicItem)item;
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        this.m_142416_((GuiEventListener)new AbilityUpgradeButtonWidget((this.f_96543_ - this.backgroundWidth) / 2 + 209, (this.f_96544_ - this.backgroundHeight) / 2 + 93, this, this.ability));
        this.m_142416_((GuiEventListener)new AbilityRerollButtonWidget((this.f_96543_ - this.backgroundWidth) / 2 + 209, (this.f_96544_ - this.backgroundHeight) / 2 + 116, this, this.ability));
        this.m_142416_((GuiEventListener)new AbilityResetButtonWidget((this.f_96543_ - this.backgroundWidth) / 2 + 209, (this.f_96544_ - this.backgroundHeight) / 2 + 139, this, this.ability));
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        int points;
        BlockEntity blockEntity;
        ClientLevel world = this.MC.f_91073_;
        if (world == null || !((blockEntity = world.m_7702_(this.pos)) instanceof ResearchingTableTile)) {
            return;
        }
        ResearchingTableTile tile = (ResearchingTableTile)blockEntity;
        this.stack = tile.getStack();
        Item item = this.stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return;
        }
        RelicItem relic = (RelicItem)item;
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        RelicAbilityEntry abilityData = RelicItem.getAbilityEntryData(relic, this.ability);
        if (abilityData == null) {
            return;
        }
        TextureManager manager = this.MC.m_91097_();
        this.m_7333_(pPoseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        int texWidth = 512;
        int texHeight = 512;
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.backgroundWidth, (int)this.backgroundHeight, (int)texWidth, (int)texHeight);
        int level = RelicItem.getAbilityPoints(this.stack, this.ability);
        int maxLevel = abilityData.getMaxLevel() == -1 ? relicData.getLevelingData().getMaxLevel() / abilityData.getRequiredPoints() : abilityData.getMaxLevel();
        TranslatableComponent name = new TranslatableComponent("tooltip.relics." + relic.getRegistryName().m_135815_() + ".ability." + this.ability);
        if (abilityData.getStats().size() > 0) {
            name.m_7220_((Component)new TranslatableComponent("tooltip.relics.relic.ability.level", new Object[]{level, maxLevel == -1 ? "\u221e" : Integer.valueOf(maxLevel)}));
        }
        this.MC.f_91062_.m_92763_(pPoseStack, (Component)name, (float)x + (float)(this.backgroundWidth - this.MC.f_91062_.m_92852_((FormattedText)name)) / 2.0f, (float)(y + 6), 0xFFFFFF);
        List lines = this.MC.f_91062_.m_92923_((FormattedText)new TranslatableComponent("tooltip.relics." + this.stack.m_41720_().getRegistryName().m_135815_() + ".ability." + this.ability + ".description"), 318);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            pPoseStack.m_85836_();
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.MC.f_91062_.m_92877_(pPoseStack, line, (float)(x * 2 + 132), (float)(y * 2 + i * 9 + 66), 4269832);
            pPoseStack.m_85849_();
        }
        boolean isHoveringUpgrade = pMouseX >= x + 209 && pMouseY >= y + 93 && pMouseX < x + 209 + 22 && pMouseY < y + 93 + 22;
        boolean isHoveringReroll = pMouseX >= x + 209 && pMouseY >= y + 116 && pMouseX < x + 209 + 22 && pMouseY < y + 116 + 22;
        boolean isHoveringReset = pMouseX >= x + 209 && pMouseY >= y + 139 && pMouseX < x + 209 + 22 && pMouseY < y + 139 + 22;
        Set<String> stats = RelicItem.getAbilityInitialValues(this.stack, this.ability).keySet();
        int yOff = 0;
        for (int i = 0; i < stats.size(); ++i) {
            String stat = (String)stats.stream().toList().get(i);
            RelicAbilityStat statData = RelicItem.getAbilityStat(relic, this.ability, stat);
            if (statData == null) continue;
            TextComponent cost = new TextComponent(String.valueOf(statData.getFormatValue().apply(RelicItem.getAbilityValue(this.stack, this.ability, stat))));
            if (isHoveringUpgrade && level < maxLevel) {
                cost.m_130946_(" -> " + statData.getFormatValue().apply(RelicItem.getAbilityValue(this.stack, this.ability, stat, level + 1)));
            }
            if (isHoveringReroll) {
                cost.m_130946_(" -> ").m_7220_((Component)new TextComponent("X.XXX").m_130940_(ChatFormatting.OBFUSCATED));
            }
            if (isHoveringReset && level > 0) {
                cost.m_130946_(" -> " + statData.getFormatValue().apply(RelicItem.getAbilityValue(this.stack, this.ability, stat, 0)));
            }
            TranslatableComponent start = new TranslatableComponent("tooltip.relics." + this.stack.m_41720_().getRegistryName().m_135815_() + ".ability." + this.ability + ".stat." + stat, new Object[]{cost});
            pPoseStack.m_85836_();
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.MC.f_91062_.m_92889_(pPoseStack, (Component)start, (float)(x * 2 + 70), (float)(y * 2 + yOff + 206), 4269832);
            pPoseStack.m_85849_();
            yOff += 9;
        }
        boolean showInfo = false;
        String info = "";
        int cost = 0;
        if (isHoveringUpgrade) {
            info = "upgrade";
            showInfo = !RelicItem.isAbilityMaxLevel(this.stack, this.ability);
            cost = RelicItem.getUpgradeRequiredExperience(this.stack, this.ability);
        }
        if (isHoveringReroll) {
            info = "reroll";
            showInfo = RelicItem.mayReroll(this.stack, this.ability);
            cost = RelicItem.getRerollRequiredExperience(this.stack, this.ability);
        }
        if (isHoveringReset) {
            info = "reset";
            showInfo = RelicItem.mayReset(this.stack, this.ability);
            cost = RelicItem.getResetRequiredExperience(this.stack, this.ability);
        }
        if (!info.isEmpty()) {
            pPoseStack.m_85836_();
            pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.MC.f_91062_.m_92889_(pPoseStack, (Component)new TranslatableComponent("tooltip.relics.relic." + info + ".description"), (float)(x * 2 + 70), (float)(y * 2 + 206 + (yOff += 9)), 4269832);
            this.MC.f_91062_.m_92889_(pPoseStack, (Component)new TranslatableComponent("tooltip.relics.relic." + info + ".cost", new Object[]{showInfo ? Integer.valueOf(cost) : "\u221e", showInfo ? Integer.valueOf(abilityData.getRequiredPoints()) : "\u221e"}), (float)(x * 2 + 70), (float)(y * 2 + 206 + (yOff += 9)), 4269832);
            pPoseStack.m_85849_();
        }
        if ((points = RelicItem.getPoints(this.stack)) > 0) {
            manager.m_174784_(WIDGETS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
            AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + this.backgroundWidth - 3), (int)(y + 31), (float)0.0f, (float)0.0f, (int)40, (int)25, (int)texWidth, (int)texHeight);
            AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + this.backgroundWidth + 16), (int)(y + 36), (float)0.0f, (float)27.0f, (int)16, (int)13, (int)texWidth, (int)texHeight);
            String value = String.valueOf(points);
            this.MC.f_91062_.m_92883_(pPoseStack, value, (float)(x + this.backgroundWidth + 7) - (float)this.f_96547_.m_92895_(value) / 2.0f, (float)(y + 39), 0xFFFFFF);
        }
        ResourceLocation card = new ResourceLocation("relics", "textures/gui/description/cards/" + this.stack.m_41720_().getRegistryName().m_135815_() + "/" + this.ability + ".png");
        RenderSystem.m_157456_((int)0, (ResourceLocation)card);
        manager.m_174784_(card);
        if (GlStateManager.m_84384_((int)3553, (int)0, (int)4097) == 29) {
            AbilityDescriptionScreen.m_93160_((PoseStack)pPoseStack, (int)(x + 30), (int)(y + 28), (int)30, (int)43, (float)0.0f, (float)0.0f, (int)20, (int)29, (int)20, (int)29);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        AbilityDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 26), (int)(y + 25), (float)356.0f, (float)0.0f, (int)38, (int)48, (int)texWidth, (int)texHeight);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    public void m_7379_() {
        this.MC.m_91152_((Screen)new RelicDescriptionScreen(this.pos, this.stack));
    }

    public boolean m_7043_() {
        return false;
    }
}

