/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.card.AbilityCardIconWidget;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RelicDescriptionScreen
extends Screen {
    private final Minecraft MC = Minecraft.m_91087_();
    public static final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/gui/description/relic_background.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("relics", "textures/gui/description/relic_widgets.png");
    public final BlockPos pos;
    public final ItemStack stack;
    public int backgroundHeight = 177;
    public int backgroundWidth = 256;

    public RelicDescriptionScreen(BlockPos pos, ItemStack stack) {
        super(TextComponent.f_131282_);
        this.pos = pos;
        this.stack = stack;
    }

    protected void m_7856_() {
        Item item = this.stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return;
        }
        RelicItem relic = (RelicItem)item;
        TextureManager manager = this.MC.m_91097_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        RelicAbilityData abilityData = relicData.getAbilityData();
        if (abilityData != null) {
            int step = 0;
            for (Map.Entry<String, RelicAbilityEntry> ability : abilityData.getAbilities().entrySet()) {
                this.m_142416_((GuiEventListener)new AbilityCardIconWidget((this.f_96543_ - this.backgroundWidth) / 2 + 54 + step, (this.f_96544_ - this.backgroundHeight) / 2 + 124, this, ability.getKey()));
                step += 30;
            }
        }
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        boolean isHoveringExperience;
        boolean isMaxLevel;
        Item item = this.stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return;
        }
        RelicItem relic = (RelicItem)item;
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        TextureManager manager = this.MC.m_91097_();
        this.m_7333_(pPoseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        manager.m_174784_(TEXTURE);
        int texWidth = 512;
        int texHeight = 512;
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.backgroundWidth, (int)this.backgroundHeight, (int)texWidth, (int)texHeight);
        int level = RelicItem.getLevel(this.stack);
        int maxLevel = relicData.getLevelingData().getMaxLevel();
        int percentage = RelicItem.getExperience(this.stack) / (RelicItem.getExperienceBetweenLevels(this.stack, level, level + 1) / 100);
        boolean bl = isMaxLevel = RelicItem.getLevel(this.stack) >= maxLevel;
        if (isMaxLevel) {
            RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 57), (int)(y + 89), (float)258.0f, (float)80.0f, (int)142, (int)12, (int)texWidth, (int)texHeight);
        } else {
            RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 74), (int)(y + 89), (float)275.0f, (float)80.0f, (int)((int)Math.ceil((float)percentage / 100.0f * 109.0f)), (int)10, (int)texWidth, (int)texHeight);
        }
        boolean bl2 = isHoveringExperience = pMouseX >= x + 55 && pMouseY >= y + 87 && pMouseX < x + 55 + 146 && pMouseY < y + 87 + 17;
        if (isHoveringExperience) {
            RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + 54), (int)(y + 79), (float)364.0f, (float)0.0f, (int)148, (int)26, (int)texWidth, (int)texHeight);
        }
        MutableComponent name = new TextComponent(this.stack.m_41611_().getString().replace("[", "").replace("]", "")).m_7220_((Component)new TranslatableComponent("tooltip.relics.relic.level", new Object[]{level, maxLevel == -1 ? "\u221e" : Integer.valueOf(maxLevel)}));
        this.MC.f_91062_.m_92763_(pPoseStack, (Component)name, (float)x + (float)(this.backgroundWidth - this.MC.f_91062_.m_92852_((FormattedText)name)) / 2.0f, (float)(y + 6), 0xFFFFFF);
        pPoseStack.m_85836_();
        TranslatableComponent experience = isMaxLevel ? new TranslatableComponent("tooltip.relics.relic.max_level") : new TextComponent(RelicItem.getExperience(this.stack) + "/" + RelicItem.getExperienceBetweenLevels(this.stack, level, level + 1) + " [" + percentage + "%]");
        pPoseStack.m_85841_(0.5f, 0.5f, 1.0f);
        this.MC.f_91062_.m_92763_(pPoseStack, (Component)experience, ((float)(x + 128) - (float)this.f_96547_.m_92852_((FormattedText)experience) / 4.0f) * 2.0f, (float)((y + 85) * 2), 0xFFFFFF);
        pPoseStack.m_85849_();
        if (!isMaxLevel) {
            this.MC.f_91062_.m_92750_(pPoseStack, String.valueOf(level), (float)(x + 66) - (float)this.MC.f_91062_.m_92895_(String.valueOf(level)) / 2.0f, (float)(y + 91), 0xFFFFFF);
            this.MC.f_91062_.m_92750_(pPoseStack, String.valueOf(level + 1), (float)(x + 190) - (float)this.MC.f_91062_.m_92895_(String.valueOf(level + 1)) / 2.0f, (float)(y + 91), 0xFFFFFF);
        }
        TranslatableComponent description = isHoveringExperience ? new TranslatableComponent("tooltip.relics.relic.leveling.title").m_7220_((Component)new TranslatableComponent("tooltip.relics." + relic.getRegistryName().m_135815_() + ".leveling")) : new TranslatableComponent("tooltip.relics." + relic.getRegistryName().m_135815_() + ".lore");
        List lines = this.MC.f_91062_.m_92923_((FormattedText)description, 240);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 1.0f);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            Font font = this.MC.f_91062_;
            float f = x * 2 + 256 - Math.round((float)this.f_96547_.m_92724_(line) / 2.0f);
            int n = lines.size();
            Objects.requireNonNull(this.MC.f_91062_);
            font.m_92877_(pPoseStack, line, f, (float)(y * 2 + i * 9 + 62 + (40 - Math.round((float)(n * 9) / 2.0f))), 4269832);
        }
        pPoseStack.m_85849_();
        int points = RelicItem.getPoints(this.stack);
        if (points > 0) {
            manager.m_174784_(WIDGETS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
            RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + this.backgroundWidth - 3), (int)(y + 31), (float)0.0f, (float)0.0f, (int)40, (int)25, (int)texWidth, (int)texHeight);
            RelicDescriptionScreen.m_93133_((PoseStack)pPoseStack, (int)(x + this.backgroundWidth + 16), (int)(y + 36), (float)0.0f, (float)27.0f, (int)16, (int)13, (int)texWidth, (int)texHeight);
            String value = String.valueOf(points);
            this.MC.f_91062_.m_92883_(pPoseStack, value, (float)(x + this.backgroundWidth + 7) - (float)this.f_96547_.m_92895_(value) / 2.0f, (float)(y + 39), 0xFFFFFF);
        }
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_7043_() {
        return false;
    }
}

