/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.tooltip;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.events.common.TooltipDisplayEvent;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="relics", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TooltipBorderHandler {
    @SubscribeEvent
    public static void onTooltipDisplay(TooltipDisplayEvent event) {
        ItemStack stack = event.getStack();
        PoseStack poseStack = event.getPoseStack();
        int width = event.getWidth();
        int height = event.getHeight();
        int x = event.getX();
        int y = event.getY();
        if (TooltipBorderHandler.getBorderColors(stack) == null) {
            return;
        }
        ResourceLocation texture = new ResourceLocation("relics", "textures/gui/tooltip/" + stack.m_41720_().getRegistryName().m_135815_() + ".png");
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        Minecraft.m_91087_().m_91097_().m_118506_(texture).m_117966_();
        int texWidth = GlStateManager.m_84384_((int)3553, (int)0, (int)4096);
        int texHeight = GlStateManager.m_84384_((int)3553, (int)0, (int)4097);
        if (texHeight == 0 || texWidth == 0) {
            return;
        }
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        poseStack.m_85837_(0.0, 0.0, 410.0);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x - 8 - 6), (int)(y - 8 - 6), (float)1.0f, (float)(1 % texHeight), (int)16, (int)16, (int)texWidth, (int)texHeight);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width - 8 + 6), (int)(y - 8 - 6), (float)(texWidth - 16 - 1), (float)(1 % texHeight), (int)16, (int)16, (int)texWidth, (int)texHeight);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x - 8 - 6), (int)(y + height - 8 + 6), (float)1.0f, (float)(1 % texHeight + 16), (int)16, (int)16, (int)texWidth, (int)texHeight);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width - 8 + 6), (int)(y + height - 8 + 6), (float)(texWidth - 16 - 1), (float)(1 % texHeight + 16), (int)16, (int)16, (int)texWidth, (int)texHeight);
        if (width >= 94) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width / 2 - 47), (int)(y - 16), (float)(16 + 2 * texWidth + 1), (float)(1 % texHeight), (int)94, (int)16, (int)texWidth, (int)texHeight);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width / 2 - 47), (int)(y + height), (float)(16 + 2 * texWidth + 1), (float)(1 % texHeight + 16), (int)94, (int)16, (int)texWidth, (int)texHeight);
        }
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.m_41720_() instanceof RelicItem)) {
            return;
        }
        Pair<String, String> colors = TooltipBorderHandler.getBorderColors(stack);
        Color color = new Color(stack.m_41791_().f_43022_.m_126665_()).darker();
        int top = colors == null ? color.getRGB() : Color.decode((String)colors.getLeft()).getRGB();
        int bottom = colors == null ? color.darker().darker().getRGB() : Color.decode((String)colors.getRight()).getRGB();
        event.setBorderStart(top);
        event.setBorderEnd(bottom);
    }

    @Nullable
    public static Pair<String, String> getBorderColors(ItemStack stack) {
        return null;
    }
}

