/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class FallingStarEntity
extends ThrowableProjectile {
    public static final String TAG_DAMAGE = "damage";
    private float damage;
    public Player owner;

    public FallingStarEntity(EntityType<? extends FallingStarEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public FallingStarEntity(LivingEntity throwerIn, LivingEntity target, float damage) {
        super((EntityType)EntityRegistry.STELLAR_CATALYST_PROJECTILE.get(), throwerIn, target.m_20193_());
        this.damage = damage;
        if (throwerIn instanceof Player) {
            this.owner = (Player)throwerIn;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Random random = this.m_20193_().m_5822_();
        for (int i = 0; i < 5; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)new CircleTintData(new Color(255 - random.nextInt(150), 0, 255 - random.nextInt(150)), 0.2f + random.nextFloat() * 0.15f, 20, 0.95f, false), this.f_19854_, this.f_19855_, this.f_19856_, (double)(MathUtils.randomFloat(random) * 0.2f), (double)(random.nextFloat() * 0.75f), (double)(MathUtils.randomFloat(random) * 0.2f));
        }
        if (this.f_19797_ > 100) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.m_20334_(0.0, -0.1 - (double)((float)this.f_19797_ * 0.01f), 0.0);
    }

    protected void m_6532_(@NotNull HitResult result) {
        Random random = this.m_20193_().m_5822_();
        ParticleUtils.createBall(new CircleTintData(new Color(255 - random.nextInt(100), 0, 255 - random.nextInt(100)), 0.4f, 40, 0.9f, true), this.m_20182_(), this.m_20193_(), 2, 0.2f);
        ParticleUtils.createBall(new CircleTintData(new Color(175 - random.nextInt(100), 0, 255 - random.nextInt(50)), 0.4f, 40, 0.9f, true), this.m_20182_(), this.m_20193_(), 1, 0.1f);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        for (LivingEntity entity : this.m_20193_().m_45976_(LivingEntity.class, this.m_142469_().m_82400_(5.0))) {
            float multiplier = 1.0f;
            Vec3 motion = entity.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82542_((double)multiplier, (double)multiplier, (double)multiplier);
            if (entity instanceof ServerPlayer && entity != this.owner) {
                NetworkHandler.sendToClient(new PacketPlayerMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_), (ServerPlayer)entity);
            } else {
                entity.m_20256_(motion);
            }
            if (this.owner == null || entity == this.owner) continue;
            entity.m_6469_(new IndirectEntityDamageSource("falling_star", (Entity)this, (Entity)this.owner).m_19366_(), this.damage);
        }
        this.m_6089_();
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
        compound.m_128350_(TAG_DAMAGE, this.damage);
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
        this.damage = compound.m_128457_(TAG_DAMAGE);
    }

    protected void m_8097_() {
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

