/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import java.awt.Color;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class PoisonedPuddleEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(PoisonedPuddleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private ItemStack stack = ItemStack.f_41583_;

    public void setSize(float amount) {
        this.m_20088_().m_135381_(SIZE, (Object)Float.valueOf(Math.min(10.0f, amount)));
    }

    public float getSize() {
        return ((Float)this.m_20088_().m_135370_(SIZE)).floatValue();
    }

    public void addSize(float amount) {
        this.setSize(this.getSize() + amount);
    }

    public PoisonedPuddleEntity(EntityType<? extends PoisonedPuddleEntity> type, Level worldIn) {
        super(type, worldIn);
        this.setSize(1.0f);
    }

    public PoisonedPuddleEntity(Entity throwerIn) {
        super((EntityType)EntityRegistry.POISONED_PUDDLE.get(), throwerIn.m_20193_());
        this.m_5602_(throwerIn);
        this.setSize(1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getSize() > 0.5f) {
            this.addSize((float)(-Math.max(RelicItem.getAbilityValue(this.stack, "spore", "resize"), 0.01)));
        } else {
            this.m_146870_();
        }
        float size = this.getSize();
        int i = 0;
        while ((float)i < (10.0f - size / 2.0f) * 3.0f) {
            float angle = this.f_19796_.nextInt(360);
            double extraX = Math.min(1.0, this.f_19796_.nextDouble() * 1.75) * ((double)size * Math.sin(angle + (float)this.f_19797_)) + this.m_20185_();
            double extraZ = Math.min(1.0, this.f_19796_.nextDouble() * 1.75) * ((double)size * Math.cos(angle + (float)this.f_19797_)) + this.m_20189_();
            this.f_19853_.m_7106_((ParticleOptions)new CircleTintData(new Color(25 + this.f_19796_.nextInt(50), 175 + this.f_19796_.nextInt(75), 0), 0.15f + size * 0.035f, Math.round(size * 10.0f), Math.min(0.99f, 0.95f + size * 0.005f), false), extraX, this.m_20186_(), extraZ, 0.0, (double)(this.f_19796_.nextFloat() * 0.015f), 0.0);
            ++i;
        }
        if (this.f_19853_.m_5776_()) {
            return;
        }
        for (LivingEntity entity : this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_())) {
            Player player;
            if (this.m_20182_().m_82554_(entity.m_20182_()) > (double)(size + 0.5f)) continue;
            Entity entity2 = this.m_37282_();
            if (entity2 instanceof Player) {
                player = (Player)entity2;
                if (entity.m_20149_().equals(player.m_20149_())) continue;
            }
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, entity.m_21124_(MobEffects.f_19614_) == null ? 20 : entity.m_21124_(MobEffects.f_19614_).m_19557_() + 2, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, entity.m_21124_(MobEffects.f_19597_) == null ? 20 : entity.m_21124_(MobEffects.f_19597_).m_19557_() + 2, 0));
            entity2 = this.m_37282_();
            if (!(entity2 instanceof Player)) continue;
            player = (Player)entity2;
            entity.m_6598_(player);
            if (this.f_19797_ % 20 != 0) continue;
            RelicItem.addExperience((Entity)player, this.stack, 1);
        }
        for (PoisonedPuddleEntity puddle : this.f_19853_.m_45976_(PoisonedPuddleEntity.class, this.m_142469_())) {
            if (puddle.m_20149_().equals(this.m_20149_()) || puddle.getSize() > size) continue;
            this.addSize(puddle.getSize() * 0.1f);
            puddle.m_146870_();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        this.setSize(compound.m_128457_("size"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("size", this.getSize());
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (SIZE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_7139_() {
        return 0.0f;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return EntityDimensions.m_20395_((float)(this.getSize() * 2.0f), (float)0.5f);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

