/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.entities.PoisonedPuddleEntity;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class SporeEntity
extends ThrowableProjectile {
    private float size;
    private ItemStack stack = ItemStack.f_41583_;

    public SporeEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
        this.size = 0.35f + level.m_5822_().nextFloat() * 0.5f;
    }

    public SporeEntity(Level level) {
        super((EntityType)EntityRegistry.SPORE.get(), level);
        this.size = 0.35f + level.m_5822_().nextFloat() * 0.5f;
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.f_19797_ > 200) {
            this.m_146870_();
        }
        if ((level = this.m_183503_()).m_5776_()) {
            return;
        }
        ((ServerLevel)level).m_8767_((ParticleOptions)new CircleTintData(new Color(level.m_5822_().nextInt(200), 255, 0), this.size * 0.25f, 40, 0.9f, false), this.f_19854_, this.f_19855_, this.f_19856_, 1, 0.025, 0.025, 0.025, (double)0.01f);
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState state = this.f_19853_.m_8055_(pos);
        if (!state.m_60767_().m_76334_()) {
            return;
        }
        this.f_19853_.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.MASTER, 0.75f, 1.75f);
        Entity entity = this.m_37282_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Optional optional = this.f_19853_.m_45976_(PoisonedPuddleEntity.class, this.m_142469_().m_82400_(1.0)).stream().findFirst();
            if (optional.isEmpty()) {
                PoisonedPuddleEntity puddle = new PoisonedPuddleEntity((Entity)player);
                puddle.m_146884_(this.m_20182_());
                puddle.m_5602_((Entity)player);
                puddle.setStack(this.stack);
                puddle.setSize(1.0f);
                this.f_19853_.m_7967_((Entity)puddle);
            } else {
                PoisonedPuddleEntity puddle = (PoisonedPuddleEntity)((Object)optional.get());
                puddle.addSize((10.0f - puddle.getSize()) * 0.1f);
            }
        }
        this.m_146870_();
    }

    public void onRemovedFromWorld() {
        ParticleUtils.createBall(new CircleTintData(new Color(100 + this.f_19853_.m_5822_().nextInt(50), 255, 0), 0.2f, 40, 0.9f, true), this.m_20182_(), this.f_19853_, 1, 0.1f);
        super.onRemovedFromWorld();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.size = compound.m_128457_("size");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("size", this.size);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

