/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.init;

import it.hurts.sskirillss.relics.client.renderer.entities.BlockSimulationRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.DissectionRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.NullRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.ShadowGlaiveRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.ShadowSawRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.SolidSnowballRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.SporeRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.StalactiteRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.StellarCatalystProjectileRenderer;
import it.hurts.sskirillss.relics.client.renderer.tiles.ResearchingTableRenderer;
import it.hurts.sskirillss.relics.init.BlockRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.HotkeyRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.TileRegistry;
import it.hurts.sskirillss.relics.items.relics.back.ArrowQuiverItem;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="relics", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RemoteRegistry {
    public static final ResourceLocation CIRCLE = new ResourceLocation("relics", "particle/circle_tint");
    public static final ResourceLocation SPARK = new ResourceLocation("relics", "particle/spark_tint");

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        ResourceLocation location = event.getAtlas().m_118330_();
        if (location.equals((Object)TextureAtlas.f_118259_)) {
            event.addSprite(new ResourceLocation("relics", "gui/curios/empty_talisman_slot"));
            event.addSprite(new ResourceLocation("relics", "gui/curios/empty_feet_slot"));
        }
        if (location.equals((Object)TextureAtlas.f_118260_)) {
            event.addSprite(CIRCLE);
            event.addSprite(SPARK);
        }
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.RESEARCHING_TABLE.get()), (RenderType)RenderType.m_110463_());
        HotkeyRegistry.register();
        ItemProperties.register((Item)((Item)ItemRegistry.INFINITY_HAM.get()), (ResourceLocation)new ResourceLocation("relics", "pieces"), (stack, world, entity, id) -> Math.min(10, NBTUtils.getInt(stack, "pieces", 0)));
        ItemProperties.register((Item)((Item)ItemRegistry.SHADOW_GLAIVE.get()), (ResourceLocation)new ResourceLocation("relics", "charges"), (stack, world, entity, id) -> Math.min(8, NBTUtils.getInt(stack, "charges", 0)));
        ItemProperties.register((Item)((Item)ItemRegistry.MAGIC_MIRROR.get()), (ResourceLocation)new ResourceLocation("relics", "world"), (stack, world, entity, id) -> {
            Entity e = Minecraft.m_91087_().m_91288_();
            if (e == null) {
                return 0.0f;
            }
            return switch (e.m_183503_().m_46472_().m_135782_().m_135815_()) {
                case "overworld" -> 1.0f;
                case "the_nether" -> 2.0f;
                case "the_end" -> 3.0f;
                default -> 0.0f;
            };
        });
        ItemProperties.register((Item)((Item)ItemRegistry.SHADOW_GLAIVE.get()), (ResourceLocation)new ResourceLocation("relics", "charges"), (stack, world, entity, id) -> Math.min(8, NBTUtils.getInt(stack, "charges", 0)));
        ItemProperties.register((Item)((Item)ItemRegistry.MAGMA_WALKER.get()), (ResourceLocation)new ResourceLocation("relics", "heat"), (stack, world, entity, id) -> {
            int maxHeat;
            int heat = NBTUtils.getInt(stack, "heat", 0);
            return heat > (maxHeat = (int)Math.round(ArrowQuiverItem.getAbilityValue(stack, "pace", "heat"))) ? 4.0f : (float)((int)Math.floor((float)heat / ((float)maxHeat / 4.0f)));
        });
        ItemProperties.register((Item)((Item)ItemRegistry.AQUA_WALKER.get()), (ResourceLocation)new ResourceLocation("relics", "drench"), (stack, world, entity, id) -> {
            int drench = NBTUtils.getInt(stack, "drench", 0);
            return (int)Math.floor((double)drench / (ArrowQuiverItem.getAbilityValue(stack, "walking", "time") / 4.0));
        });
        ItemProperties.register((Item)((Item)ItemRegistry.ARROW_QUIVER.get()), (ResourceLocation)new ResourceLocation("relics", "fullness"), (stack, world, entity, id) -> {
            int maxAmount = ArrowQuiverItem.getSlotsAmount(stack);
            int amount = ArrowQuiverItem.getArrows(stack).size();
            return amount > 0 ? (float)((int)Math.floor((float)amount / ((float)maxAmount / 2.0f)) + 1) : 0.0f;
        });
        ItemProperties.register((Item)((Item)ItemRegistry.ELYTRA_BOOSTER.get()), (ResourceLocation)new ResourceLocation("relics", "fuel"), (stack, world, entity, id) -> {
            int fuel = NBTUtils.getInt(stack, "fuel", 0);
            return (int)Math.ceil((double)fuel / (ArrowQuiverItem.getAbilityValue(stack, "boost", "capacity") / 5.0));
        });
        ItemProperties.register((Item)((Item)ItemRegistry.SOLID_SNOWBALL.get()), (ResourceLocation)new ResourceLocation("relics", "snow"), (stack, world, entity, id) -> {
            ItemStack relic = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.WOOL_MITTEN.get());
            return (int)Math.floor((double)NBTUtils.getInt(stack, "snow", 0) / (RelicItem.getAbilityValue(relic, "mold", "size") / 3.0));
        });
        ItemProperties.register((Item)((Item)ItemRegistry.ROLLER_SKATES.get()), (ResourceLocation)new ResourceLocation("relics", "active"), (stack, world, entity, id) -> NBTUtils.getInt(stack, "duration", 0) > 0 ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)ItemRegistry.BLAZING_FLASK.get()), (ResourceLocation)new ResourceLocation("relics", "active"), (stack, world, entity, id) -> NBTUtils.getString(stack, "pos", "").isEmpty() ? 0.0f : 1.0f);
        MinecraftForgeClient.registerTooltipComponentFactory(ArrowQuiverItem.ArrowQuiverTooltip.class, ArrowQuiverItem.ClientArrowQuiverTooltip::new);
    }

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.STELLAR_CATALYST_PROJECTILE.get(), (EntityRendererProvider)new StellarCatalystProjectileRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.SHADOW_GLAIVE.get(), (EntityRendererProvider)new ShadowGlaiveRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.BLOCK_SIMULATION.get(), (EntityRendererProvider)new BlockSimulationRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.SHOCKWAVE.get(), (EntityRendererProvider)new NullRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.LIFE_ESSENCE.get(), (EntityRendererProvider)new NullRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.STALACTITE.get(), (EntityRendererProvider)new StalactiteRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.DISSECTION.get(), (EntityRendererProvider)new DissectionRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.SPORE.get(), (EntityRendererProvider)new SporeRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.SHADOW_SAW.get(), (EntityRendererProvider)new ShadowSawRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.POISONED_PUDDLE.get(), (EntityRendererProvider)new NullRenderer.RenderFactory());
        event.registerEntityRenderer((EntityType)EntityRegistry.SOLID_SNOWBALL.get(), (EntityRendererProvider)new SolidSnowballRenderer.RenderFactory());
        event.registerBlockEntityRenderer((BlockEntityType)TileRegistry.RESEARCHING_TABLE.get(), ResearchingTableRenderer::new);
    }
}

