/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlazingFlaskItem
extends RelicItem {
    public static final String TAG_POSITION = "pos";
    public static final String TAG_COUNT = "count";
    public static final String TAG_RADIUS = "radius";

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("bonfire", RelicAbilityEntry.builder().stat("step", RelicAbilityStat.builder().initialValue(1.0, 2.5).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 1)).build()).stat("speed", RelicAbilityStat.builder().initialValue(0.01, 0.05).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 1.9).formatValue(value -> MathUtils.round(value * 8.0, 1)).build()).stat("height", RelicAbilityStat.builder().initialValue(3.0, 5.0).upgradeModifier(RelicAbilityStat.Operation.ADD, 1.0).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#eed551", "#dcbe1d").build()).build();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        Player player;
        block18: {
            block17: {
                if (!(entity instanceof Player)) break block17;
                player = (Player)entity;
                if (!DurabilityUtils.isBroken(stack)) break block18;
            }
            return;
        }
        Level world = player.m_20193_();
        int fire = this.getFireAround(stack, world);
        if (fire <= 0) {
            NBTUtils.clearTag(stack, TAG_POSITION);
            NBTUtils.clearTag(stack, TAG_COUNT);
        } else {
            NBTUtils.setInt(stack, TAG_COUNT, fire);
        }
        Vec3 center = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
        if (center != null) {
            double radius = NBTUtils.getDouble(stack, TAG_RADIUS, 0.0);
            if (!(player.m_7500_() || player.m_5833_() || player.m_150110_().f_35935_ || player.m_150110_().f_35936_)) {
                Vec3 vec3 = new Vec3(player.m_20185_(), center.m_7098_(), player.m_20189_());
                if (vec3.m_82554_(center) <= radius + 0.5) {
                    player.f_19789_ = 0.0f;
                    if (player.f_19797_ % 100 == 0) {
                        BlazingFlaskItem.addExperience((Entity)player, stack, 1);
                    }
                    double speed = BlazingFlaskItem.getAbilityValue(stack, "bonfire", "speed");
                    if (world.m_5776_()) {
                        if (!(player.m_20096_() || player.f_20902_ == 0.0f && player.f_20900_ == 0.0f)) {
                            player.m_6478_(MoverType.SELF, player.m_20184_().m_82542_(speed, 0.0, speed));
                        }
                        if (player instanceof LocalPlayer) {
                            LocalPlayer localPlayer = (LocalPlayer)player;
                            if (localPlayer.f_108618_.f_108572_ && this.getGroundHeight(player) + BlazingFlaskItem.getAbilityValue(stack, "bonfire", "height") - player.m_20186_() > 0.0) {
                                Vec3 motion = player.m_20184_();
                                if (motion.m_7098_() < 0.0) {
                                    player.m_20334_(motion.m_7096_(), motion.m_7098_() * (double)0.9f, motion.m_7094_());
                                }
                                player.m_20256_(player.m_20184_().m_82520_(0.0, (double)0.1f, 0.0));
                            }
                        }
                    }
                }
            }
            double size = (double)NBTUtils.getInt(stack, TAG_COUNT, 0) * BlazingFlaskItem.getAbilityValue(stack, "bonfire", "step");
            double step = 0.1;
            int time = 0;
            if (radius < size) {
                radius = radius + step < size ? (radius += step) : size;
                time = 10;
                NBTUtils.setDouble(stack, TAG_RADIUS, radius);
            }
            if (radius > size) {
                radius = radius - step > size ? (radius -= step) : size;
                time = 10;
                NBTUtils.setDouble(stack, TAG_RADIUS, radius);
            }
            if (radius <= step) {
                ParticleUtils.createBall(new CircleTintData(new Color(255, 100, 0), 0.3f, 20, 0.9f, true), center, level, 3, 0.2f);
            }
            ParticleUtils.createCyl(new CircleTintData(new Color(255, 100, 0), 0.2f, time, 0.8f, true), center, level, radius, 0.15f);
        }
    }

    protected double getGroundHeight(Player player) {
        BlockHitResult result = player.f_19853_.m_45547_(new ClipContext(player.m_20182_(), player.m_20182_().m_82520_(0.0, -64.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return result.m_82450_().m_7098_();
        }
        return -player.m_20193_().m_151558_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        float distance;
        ItemStack stack = player.m_21120_(hand);
        Vec3 view = player.m_20252_(0.0f);
        Vec3 eyeVec = player.m_20299_(0.0f);
        Vec3 end = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)(distance = (float)(8.0 + BlazingFlaskItem.getAbilityValue(stack, "bonfire", "height"))), view.f_82480_ * (double)distance, view.f_82481_ * (double)distance), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_82450_();
        if (this.getFireAround(stack, end, level) > 0) {
            Vec3 center = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
            double radius = NBTUtils.getDouble(stack, TAG_RADIUS, 0.0);
            NBTUtils.setDouble(stack, TAG_RADIUS, center != null && end.m_82554_(center) <= radius ? radius - center.m_82554_(end) : 0.0);
            NBTUtils.setString(stack, TAG_POSITION, NBTUtils.writePosition(end));
            player.m_36335_().m_41524_((Item)this, 20);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public int getFireAround(ItemStack stack, Level level) {
        Vec3 center = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
        if (center == null) {
            return 0;
        }
        return this.getFireAround(stack, center, level);
    }

    public int getFireAround(ItemStack stack, Vec3 center, Level level) {
        List<BlockPos> positions = WorldUtils.getBlockSphere(new BlockPos(center), BlazingFlaskItem.getAbilityValue(stack, "bonfire", "step")).stream().filter(pos -> level.m_8055_(pos).m_60734_() instanceof BaseFireBlock).toList();
        return positions.size();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

