/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketItemActivation;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class SpatialSignItem
extends RelicItem {
    public static final String TAG_POSITION = "pos";
    public static final String TAG_STAGE = "stage";
    public static final String TAG_TIME = "time";
    public static final String TAG_WORLD = "world";

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("seal", RelicAbilityEntry.builder().stat("speed", RelicAbilityStat.builder().initialValue(1.0, 1.5).upgradeModifier(RelicAbilityStat.Operation.ADD, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).stat("duration", RelicAbilityStat.builder().initialValue(5.0, 10.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#dc41ff", "#832698").build()).build();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (DurabilityUtils.isBroken(stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (NBTUtils.getString(stack, TAG_POSITION, "").equals("")) {
            NBTUtils.setString(stack, TAG_POSITION, NBTUtils.writePosition(playerIn.m_20182_()));
            NBTUtils.setString(stack, TAG_WORLD, playerIn.m_20193_().m_46472_().m_135782_().toString());
            NBTUtils.setInt(stack, TAG_TIME, (int)Math.round(SpatialSignItem.getAbilityValue(stack, "seal", "duration")));
            worldIn.m_5594_(playerIn, playerIn.m_142538_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (playerIn.m_6144_()) {
            String string = NBTUtils.getString(stack, TAG_POSITION, "");
            List<String> positions = Arrays.asList(string.split("\\|"));
            if (positions.size() <= 1) {
                NBTUtils.clearTag(stack, TAG_TIME);
                NBTUtils.clearTag(stack, TAG_STAGE);
                NBTUtils.clearTag(stack, TAG_POSITION);
                NBTUtils.clearTag(stack, TAG_WORLD);
            } else {
                NBTUtils.setString(stack, TAG_POSITION, string + "|" + NBTUtils.writePosition(playerIn.m_20182_()));
                NBTUtils.setInt(stack, TAG_STAGE, positions.size() - 2);
                NBTUtils.setInt(stack, TAG_TIME, 0);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Vec3 pos;
        if (DurabilityUtils.isBroken(stack) || !(entityIn instanceof Player)) {
            return;
        }
        Player player = (Player)entityIn;
        if (NBTUtils.getInt(stack, TAG_STAGE, -1) > -1) {
            player.f_19794_ = true;
        }
        if (worldIn.m_5776_()) {
            return;
        }
        Random random = worldIn.m_5822_();
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        int stage = NBTUtils.getInt(stack, TAG_STAGE, -1);
        String string = NBTUtils.getString(stack, TAG_POSITION, "");
        List<String> positions = Arrays.asList(string.split("\\|"));
        double speed = SpatialSignItem.getAbilityValue(stack, "seal", "speed");
        if (time == 0 && stage != -1) {
            float z;
            float y;
            float x;
            int j;
            Vec3 finalVec;
            int distance;
            Vec3 nextVec;
            Vec3 currentVec;
            int i;
            ServerLevel serverLevel;
            pos = NBTUtils.parsePosition(positions.get(stage));
            if (!worldIn.m_5776_()) {
                serverLevel = (ServerLevel)worldIn;
                serverLevel.m_8767_((ParticleOptions)new CircleTintData(this.getParticleColor(random, (stage + 1) % 3), 0.1f, 30, 0.9f, true), player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 0.25, 0.25, 0.25, (double)0.05f);
                for (i = positions.size() - 1; i > stage; --i) {
                    currentVec = NBTUtils.parsePosition(positions.get(i));
                    nextVec = i > stage + 1 ? NBTUtils.parsePosition(positions.get(i - 1)) : player.m_20182_().m_82520_(0.0, -1.0, 0.0);
                    distance = (int)Math.round(currentVec.m_82554_(nextVec));
                    finalVec = currentVec.m_82549_(nextVec.m_82546_(currentVec).m_82541_().m_82542_((double)distance, (double)distance, (double)distance));
                    distance = (int)Math.round(currentVec.m_82554_(finalVec)) * 10;
                    for (j = 0; j < distance; ++j) {
                        x = (float)((finalVec.f_82479_ - currentVec.f_82479_) * (double)j / (double)distance + currentVec.f_82479_);
                        y = (float)((finalVec.f_82480_ - currentVec.f_82480_) * (double)j / (double)distance + currentVec.f_82480_) + player.m_20206_() / 2.0f;
                        z = (float)((finalVec.f_82481_ - currentVec.f_82481_) * (double)j / (double)distance + currentVec.f_82481_);
                        serverLevel.m_8767_((ParticleOptions)new CircleTintData(this.getParticleColor(random, i % 3), 0.1f, 2, 0.9f, true), (double)x, (double)y, (double)z, 1, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.1f);
                    }
                }
            }
            if (pos != null) {
                if (!worldIn.m_46472_().m_135782_().toString().equals(NBTUtils.getString(stack, TAG_WORLD, "")) || pos.m_82554_(player.m_20182_()) > speed * 3.0 + 100.0) {
                    stack.m_41721_(this.getMaxDamage(stack));
                    worldIn.m_5594_(null, player.m_142538_(), SoundEvents.f_12326_, SoundSource.MASTER, 1.0f, 1.0f);
                    if (!worldIn.m_5776_()) {
                        NetworkHandler.sendToClient(new PacketItemActivation(stack), (ServerPlayer)player);
                    }
                    NBTUtils.clearTag(stack, TAG_TIME);
                    NBTUtils.clearTag(stack, TAG_POSITION);
                    NBTUtils.clearTag(stack, TAG_WORLD);
                    return;
                }
                ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(player.m_142049_(), pos.m_82520_(0.0, 1.0, 0.0).m_82546_(player.m_20182_()).m_82541_().m_82490_(speed)));
                if (player.f_19797_ % 20 == 0) {
                    SpatialSignItem.addExperience((Entity)player, stack, 1);
                }
                player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 20, 0, false, false));
                player.f_19789_ = 0.0f;
                player.m_20095_();
                if (player.m_20182_().m_82554_(pos) <= speed * 2.0) {
                    NBTUtils.setInt(stack, TAG_STAGE, --stage);
                    if (stage < 0) {
                        NBTUtils.clearTag(stack, TAG_TIME);
                        NBTUtils.clearTag(stack, TAG_STAGE);
                        NBTUtils.clearTag(stack, TAG_POSITION);
                        NBTUtils.clearTag(stack, TAG_WORLD);
                        if (!worldIn.m_5776_()) {
                            serverLevel = (ServerLevel)worldIn;
                            for (i = positions.size() - 1; i > stage; --i) {
                                currentVec = NBTUtils.parsePosition(positions.get(i));
                                nextVec = i > stage + 1 ? NBTUtils.parsePosition(positions.get(i - 1)) : player.m_20182_().m_82520_(0.0, -1.0, 0.0);
                                distance = (int)Math.round(currentVec.m_82554_(nextVec));
                                finalVec = currentVec.m_82549_(nextVec.m_82546_(currentVec).m_82541_().m_82542_((double)distance, (double)distance, (double)distance));
                                distance = (int)Math.round(currentVec.m_82554_(finalVec)) * 10;
                                for (j = 0; j < distance; ++j) {
                                    x = (float)((finalVec.f_82479_ - currentVec.f_82479_) * (double)j / (double)distance + currentVec.f_82479_);
                                    y = (float)((finalVec.f_82480_ - currentVec.f_82480_) * (double)j / (double)distance + currentVec.f_82480_) + player.m_20206_() / 2.0f;
                                    z = (float)((finalVec.f_82481_ - currentVec.f_82481_) * (double)j / (double)distance + currentVec.f_82481_);
                                    serverLevel.m_8767_((ParticleOptions)new CircleTintData(this.getParticleColor(random, i % 3), 0.2f, 30, 0.94f, true), (double)x, (double)y, (double)z, 2, (double)0.2f, (double)0.2f, (double)0.2f, (double)0.05f);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (time > 0) {
            if (player.f_19797_ % 20 == 0) {
                NBTUtils.setInt(stack, TAG_TIME, --time);
                if (time <= 10 && time > 0) {
                    worldIn.m_5594_(null, player.m_142538_(), SoundEvents.f_12490_, SoundSource.MASTER, 0.75f, 0.75f + (float)time * 0.125f);
                }
            }
            if (player.f_19797_ % 5 == 0 && !positions.isEmpty()) {
                if (!worldIn.m_46472_().m_135782_().toString().equals(NBTUtils.getString(stack, TAG_WORLD, "")) || NBTUtils.parsePosition(positions.get(positions.size() - 1)).m_82554_(player.m_20182_()) > speed * 3.0 + 100.0) {
                    stack.m_41721_(this.getMaxDamage(stack));
                    worldIn.m_5594_(null, player.m_142538_(), SoundEvents.f_12326_, SoundSource.MASTER, 1.0f, 1.0f);
                    if (!worldIn.m_5776_()) {
                        NetworkHandler.sendToClient(new PacketItemActivation(stack), (ServerPlayer)player);
                    }
                    NBTUtils.clearTag(stack, TAG_TIME);
                    NBTUtils.clearTag(stack, TAG_WORLD);
                    NBTUtils.clearTag(stack, TAG_STAGE);
                    NBTUtils.clearTag(stack, TAG_POSITION);
                    return;
                }
                pos = NBTUtils.parsePosition(positions.get(positions.size() - 1));
                if (pos != null && player.m_20182_().m_82554_(pos) > speed * 3.0) {
                    NBTUtils.setString(stack, TAG_POSITION, string + "|" + NBTUtils.writePosition(player.m_20182_()));
                }
                if (time == 0) {
                    NBTUtils.setInt(stack, TAG_STAGE, positions.size() - 1);
                }
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    private Color getParticleColor(Random random, int type) {
        return (Color)Lists.newArrayList((Object[])new Color[]{new Color(random.nextInt(50), 255, random.nextInt(50)), new Color(random.nextInt(50), random.nextInt(50), 255), new Color(255, 50 + random.nextInt(50), random.nextInt(50))}).get(type);
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_TIME, 0) > 0;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @Mod.EventBusSubscriber
    public static class ServerEvents {
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            for (int slot2 : EntityUtils.getSlotsWithItem(player, (Item)ItemRegistry.SPATIAL_SIGN.get()).stream().filter(slot -> slot != -1).toList()) {
                ItemStack stack = player.m_150109_().m_8020_(slot2);
                if (!(stack.m_41720_() instanceof SpatialSignItem) || NBTUtils.getInt(stack, SpatialSignItem.TAG_STAGE, -1) <= -1 || NBTUtils.getString(stack, SpatialSignItem.TAG_POSITION, "").isEmpty()) continue;
                event.setCanceled(true);
                return;
            }
        }
    }
}

