/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.events.common.ContainerSlotClickEvent;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ArrowQuiverItem
extends RelicItem {
    private static final String TAG_ARROWS = "arrows";

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("receptacle", RelicAbilityEntry.builder().stat("slots", RelicAbilityStat.builder().initialValue(2.0, 5.0).upgradeModifier(RelicAbilityStat.Operation.ADD, 1.0).formatValue(value -> (int)Math.round(value)).build()).build()).ability("agility", RelicAbilityEntry.builder().requiredLevel(5).requiredPoints(2).stat("modifier", RelicAbilityStat.builder().initialValue(1.0, 1.0).upgradeModifier(RelicAbilityStat.Operation.ADD, 1.0).formatValue(value -> (int)(1.0 + MathUtils.round(value, 0)) * 100).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#eed551", "#dcbe1d").build()).build();
    }

    public static int getSlotsAmount(ItemStack stack) {
        return (int)Math.round(ArrowQuiverItem.getAbilityValue(stack, "receptacle", "slots"));
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new ArrowQuiverTooltip(ArrowQuiverItem.getArrows(stack), ArrowQuiverItem.getSlotsAmount(stack)));
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        Player player;
        block6: {
            block5: {
                if (!(livingEntity instanceof Player)) break block5;
                player = (Player)livingEntity;
                if (!DurabilityUtils.isBroken(stack)) break block6;
            }
            return;
        }
        if (ArrowQuiverItem.canUseAbility(stack, "agility") && player.m_6117_() && player.m_21205_().m_41720_() instanceof BowItem) {
            for (int i = 0; i < 1; ++i) {
                player.m_21329_();
            }
        }
    }

    public static List<ItemStack> getArrows(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag == null ? new ArrayList<ItemStack>() : tag.m_128437_(TAG_ARROWS, 10).stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).collect(Collectors.toList());
    }

    public int insertStack(ItemStack stack, ItemStack arrow) {
        if (!arrow.m_41720_().m_142095_()) {
            return 0;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ARROWS)) {
            tag.m_128365_(TAG_ARROWS, (Tag)new ListTag());
        }
        ListTag list = tag.m_128437_(TAG_ARROWS, 10);
        List<CompoundTag> entries = list.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(nbt -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)nbt), (ItemStack)arrow)).filter(nbt -> {
            ItemStack item = ItemStack.m_41712_((CompoundTag)nbt);
            return item.m_41613_() < item.m_41741_();
        }).toList();
        int amount = 0;
        if (!entries.isEmpty()) {
            for (CompoundTag entry : entries) {
                ItemStack s = ItemStack.m_41712_((CompoundTag)entry);
                int count = s.m_41613_() + arrow.m_41613_();
                if (count <= s.m_41741_()) {
                    arrow.m_41764_(0);
                    s.m_41769_(amount += arrow.m_41613_());
                    s.m_41739_(entry);
                    list.remove((Object)entry);
                    list.add(0, (Tag)entry);
                    break;
                }
                int step = s.m_41741_() - s.m_41613_();
                amount += step;
                arrow.m_41774_(step);
                s.m_41769_(step);
                s.m_41739_(entry);
                list.remove((Object)entry);
                list.add(0, (Tag)entry);
            }
        }
        if (!arrow.m_41619_()) {
            if (ArrowQuiverItem.getSlotsAmount(stack) <= ArrowQuiverItem.getArrows(stack).size()) {
                return 0;
            }
            amount += arrow.m_41613_();
            CompoundTag entry = new CompoundTag();
            arrow.m_41777_().m_41739_(entry);
            list.add(0, (Tag)entry);
        }
        return amount;
    }

    public static Optional<ItemStack> takeStack(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ARROWS)) {
            return Optional.empty();
        }
        ListTag list = tag.m_128437_(TAG_ARROWS, 10);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        ItemStack s = ItemStack.m_41712_((CompoundTag)list.m_128728_(0));
        list.remove(0);
        if (list.isEmpty()) {
            stack.m_41749_(TAG_ARROWS);
        }
        return Optional.of(s);
    }

    public static void takeArrow(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ARROWS)) {
            return;
        }
        ListTag list = tag.m_128437_(TAG_ARROWS, 10);
        if (list.isEmpty()) {
            return;
        }
        CompoundTag entry = list.m_128728_(0);
        ItemStack s = ItemStack.m_41712_((CompoundTag)entry);
        s.m_41774_(1);
        s.m_41739_(entry);
        list.remove(0);
        if (!s.m_41619_()) {
            list.add(0, (Tag)entry);
        }
        if (list.isEmpty()) {
            stack.m_41749_(TAG_ARROWS);
        }
    }

    public record ArrowQuiverTooltip(List<ItemStack> items, int maxAmount) implements TooltipComponent
    {
        public List<ItemStack> getItems() {
            return this.items;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onSlotClick(ContainerSlotClickEvent event) {
            Player player = event.getPlayer();
            ItemStack heldStack = event.getHeldStack();
            ItemStack slotStack = event.getSlotStack();
            if (slotStack.m_41720_() != ItemRegistry.ARROW_QUIVER.get()) {
                return;
            }
            ArrowQuiverItem quiver = (ArrowQuiverItem)slotStack.m_41720_();
            if (event.getAction() == ClickAction.PRIMARY) {
                if (!(heldStack.m_41720_() instanceof ArrowItem)) {
                    return;
                }
                int amount = quiver.insertStack(slotStack, heldStack);
                if (amount <= 0) {
                    return;
                }
                heldStack.m_41774_(amount);
                player.m_5496_(SoundEvents.f_184215_, 1.0f, 1.0f);
                event.setCanceled(true);
            } else {
                if (!heldStack.m_41619_()) {
                    return;
                }
                ArrowQuiverItem.takeStack(slotStack).ifPresent(stack -> {
                    event.getContainer().m_142503_(stack);
                    player.m_5496_(SoundEvents.f_184216_, 1.0f, 1.0f);
                    event.setCanceled(true);
                });
            }
        }

        @SubscribeEvent
        public static void onArrowLoose(ArrowLooseEvent event) {
            Player player = event.getPlayer();
            ItemStack relic = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ARROW_QUIVER.get());
            if (relic.m_41619_() || DurabilityUtils.isBroken(relic) || ArrowQuiverItem.getArrows(relic).isEmpty() || player.m_7500_()) {
                return;
            }
            ArrowQuiverItem.takeArrow(relic);
        }

        @SubscribeEvent
        public static void onGettingProjectile(LivingGetProjectileEvent event) {
            LivingEntity livingEntity = event.getEntityLiving();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack weapon = event.getProjectileWeaponItemStack();
            if (!(weapon.m_41720_() instanceof BowItem) || weapon.m_41720_() instanceof CrossbowItem) {
                return;
            }
            ItemStack relic = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ARROW_QUIVER.get());
            if (relic.m_41619_() || DurabilityUtils.isBroken(relic)) {
                return;
            }
            List<ItemStack> arrows = ArrowQuiverItem.getArrows(relic);
            if (!arrows.isEmpty()) {
                event.setProjectileItemStack(arrows.get(0));
            }
        }

        @SubscribeEvent
        public static void onProjectileImpact(LivingHurtEvent event) {
            Player player;
            Entity entity;
            block6: {
                block5: {
                    entity = event.getSource().m_7639_();
                    if (!(entity instanceof Player)) break block5;
                    player = (Player)entity;
                    entity = event.getSource().m_7640_();
                    if (entity instanceof AbstractArrow) break block6;
                }
                return;
            }
            AbstractArrow arrow = (AbstractArrow)entity;
            ArrowQuiverItem item = (ArrowQuiverItem)((Object)ItemRegistry.ARROW_QUIVER.get());
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, item);
            if (stack.m_41619_() || DurabilityUtils.isBroken(stack)) {
                return;
            }
            int amount = (int)Math.min(10L, Math.round(player.m_20182_().m_82554_(new Vec3(arrow.m_20185_(), player.m_20186_(), arrow.m_20189_())) * 0.1));
            if (amount > 0) {
                RelicItem.addExperience((Entity)player, stack, amount);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record ClientArrowQuiverTooltip(ArrowQuiverTooltip tooltip) implements ClientTooltipComponent
    {
        public static final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/gui/tooltip/arrow_quiver/empty_arrow.png");

        public int m_142103_() {
            return 26;
        }

        public int m_142069_(Font font) {
            return this.tooltip.getMaxAmount() * 11;
        }

        public void m_183452_(Font font, int mouseX, int mouseY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 410.0);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            int step = 0;
            for (ItemStack stack : this.tooltip.getItems()) {
                font.m_92883_(poseStack, String.valueOf(stack.m_41613_()), (float)((mouseX + step) * 2) + (float)(16 - font.m_92895_(String.valueOf(stack.m_41613_()))) / 2.0f, (float)((mouseY + 16) * 2), 0xFFFFFF);
                itemRenderer.m_115218_(stack, mouseX + step, mouseY);
                step += 10;
            }
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            for (int i = step / 10; i < this.tooltip.getMaxAmount(); ++i) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                Minecraft.m_91087_().m_91097_().m_118506_(TEXTURE).m_117966_();
                Gui.m_93160_((PoseStack)poseStack, (int)(mouseX + step), (int)mouseY, (int)16, (int)16, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                step += 10;
            }
            poseStack.m_85837_(0.0, 0.0, -410.0);
            poseStack.m_85849_();
        }

        public ArrowQuiverTooltip getTooltip() {
            return this.tooltip;
        }
    }
}

