/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import it.hurts.sskirillss.relics.api.events.leveling.ExperienceAddEvent;
import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicsTab;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class RelicItem
extends Item
implements ICurioItem {
    public static final String TAG_ABILITIES = "abilities";
    public static final String TAG_STATS = "stats";
    public static final String TAG_EXPERIENCE = "experience";
    public static final String TAG_LEVELING = "leveling";
    public static final String TAG_POINTS = "points";
    public static final String TAG_LEVEL = "level";
    public static final int MAX_QUALITY = 10;

    public RelicItem(Item.Properties properties) {
        super(properties);
    }

    public RelicItem() {
        super(new Item.Properties().m_41491_(RelicsTab.RELICS_TAB).m_41497_(Rarity.RARE).m_41487_(1));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        if (DurabilityUtils.isBroken(stack)) {
            return modifiers;
        }
        RelicAttributeModifier attributes = this.getAttributeModifiers(stack);
        RelicSlotModifier slots = this.getSlotModifiers(stack);
        if (attributes != null) {
            attributes.getAttributes().forEach(arg_0 -> RelicItem.lambda$getAttributeModifiers$0((Multimap)modifiers, uuid, stack, arg_0));
        }
        if (slots != null) {
            slots.getModifiers().forEach(arg_0 -> RelicItem.lambda$getAttributeModifiers$1((Multimap)modifiers, uuid, arg_0));
        }
        return modifiers;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!DurabilityUtils.isBroken(stack)) {
            Vec3 pos = entity.m_20182_();
            Random random = entity.m_20193_().m_5822_();
            if (this.getStyle(stack) != null) {
                String hex = this.getStyle(stack).getParticles();
                Color color = hex == null || hex.isEmpty() ? new Color(stack.m_41791_().f_43022_.m_126665_()) : Color.decode(hex);
                entity.m_20193_().m_7106_((ParticleOptions)new CircleTintData(color, random.nextFloat() * 0.025f + 0.04f, 25, 0.97f, true), pos.m_7096_() + (double)(MathUtils.randomFloat(random) * 0.25f), pos.m_7098_() + (double)0.1f, pos.m_7094_() + (double)(MathUtils.randomFloat(random) * 0.25f), 0.0, (double)random.nextFloat() * 0.05, 0.0);
            }
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44986_;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 1;
    }

    public boolean showAttributesTooltip(String identifier, ItemStack stack) {
        return false;
    }

    public boolean canEquip(String identifier, LivingEntity livingEntity, ItemStack stack) {
        return !DurabilityUtils.isBroken(stack);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return !DurabilityUtils.isBroken(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return switch (stack.m_41791_()) {
            default -> throw new IncompatibleClassChangeError();
            case Rarity.COMMON -> 100;
            case Rarity.UNCOMMON -> 150;
            case Rarity.RARE -> 200;
            case Rarity.EPIC -> 250;
        };
    }

    public boolean isDamageable(ItemStack stack) {
        return stack.m_41776_() > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)this.getMaxDamage(stack));
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, ((float)this.getMaxDamage(stack) - (float)stack.m_41773_()) / (float)this.getMaxDamage(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public RelicStyleData getStyle(ItemStack stack) {
        return null;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        tooltip.add((Component)new TextComponent(" "));
        tooltip.add((Component)new TranslatableComponent("tooltip.relics.relic.table").m_130940_(ChatFormatting.GRAY));
    }

    public RelicAttributeModifier getAttributeModifiers(ItemStack stack) {
        return null;
    }

    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return null;
    }

    @Nullable
    public RelicData getRelicData() {
        return null;
    }

    public static RelicData getRelicData(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return null;
        }
        RelicItem relic = (RelicItem)item;
        return relic.getRelicData();
    }

    @Nullable
    public static RelicAbilityData getAbilityData(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return null;
        }
        RelicItem relic = (RelicItem)item;
        return RelicItem.getRelicData(stack).getAbilityData();
    }

    @Nullable
    public static RelicAbilityData getAbilityData(RelicItem relic) {
        return relic.getRelicData().getAbilityData();
    }

    @Nullable
    public static RelicAbilityEntry getAbilityEntryData(ItemStack stack, String ability) {
        Item item = stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return null;
        }
        RelicItem relic = (RelicItem)item;
        return RelicItem.getAbilityEntryData(relic, ability);
    }

    @Nullable
    public static RelicAbilityEntry getAbilityEntryData(RelicItem relic, String ability) {
        return RelicItem.getAbilityData(relic).getAbilities().get(ability);
    }

    @Nullable
    public static RelicAbilityStat getAbilityStat(ItemStack stack, String ability, String stat) {
        Item item = stack.m_41720_();
        if (!(item instanceof RelicItem)) {
            return null;
        }
        RelicItem relic = (RelicItem)item;
        return RelicItem.getAbilityStat(relic, ability, stat);
    }

    @Nullable
    public static RelicAbilityStat getAbilityStat(RelicItem relic, String ability, String stat) {
        return RelicItem.getAbilityEntryData(relic, ability).getStats().get(stat);
    }

    public static CompoundTag getAbilitiesTag(ItemStack stack) {
        return stack.m_41784_().m_128469_(TAG_ABILITIES);
    }

    public static CompoundTag getAbilityTag(ItemStack stack, String ability) {
        CompoundTag data = RelicItem.getAbilitiesTag(stack);
        if (data.m_128456_()) {
            return new CompoundTag();
        }
        return data.m_128469_(ability);
    }

    public static Map<String, Double> getAbilityInitialValues(ItemStack stack, String ability) {
        CompoundTag abilityTag = RelicItem.getAbilityTag(stack, ability);
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (abilityTag.m_128456_()) {
            return result;
        }
        CompoundTag statTag = abilityTag.m_128469_(TAG_STATS);
        if (statTag.m_128456_()) {
            return result;
        }
        statTag.m_128431_().forEach(entry -> result.put((String)entry, statTag.m_128459_(entry)));
        return result;
    }

    public static double getAbilityInitialValue(ItemStack stack, String ability, String stat) {
        return RelicItem.getAbilityInitialValues(stack, ability).getOrDefault(stat, 0.0);
    }

    public static double getAbilityValue(ItemStack stack, String ability, String stat, int points) {
        RelicAbilityStat data = RelicItem.getAbilityStat(stack, ability, stat);
        double result = 0.0;
        if (data == null) {
            return result;
        }
        double current = RelicItem.getAbilityInitialValue(stack, ability, stat);
        double step = (Double)data.getUpgradeModifier().value();
        switch ((RelicAbilityStat.Operation)((Object)data.getUpgradeModifier().first())) {
            case ADD: {
                result = current + (double)points * step;
                break;
            }
            case MULTIPLY_BASE: {
                result = current + current * step * (double)points;
                break;
            }
            case MULTIPLY_TOTAL: {
                result = current * Math.pow(step + 1.0, points);
            }
        }
        it.unimi.dsi.fastutil.Pair<Double, Double> threshold = data.getThresholdValue();
        return threshold == null ? MathUtils.round(result, 3) : MathUtils.round(Math.max((Double)threshold.first(), Math.min((Double)threshold.second(), result)), 3);
    }

    public static double getAbilityValue(ItemStack stack, String ability, String stat) {
        return RelicItem.getAbilityValue(stack, ability, stat, RelicItem.getAbilityPoints(stack, ability));
    }

    public static void setAbilityValue(ItemStack stack, String ability, String stat, double value) {
        CompoundTag data = RelicItem.getAbilitiesTag(stack);
        CompoundTag abilityTag = RelicItem.getAbilityTag(stack, ability);
        CompoundTag statTag = abilityTag.m_128469_(TAG_STATS);
        statTag.m_128347_(stat, value);
        abilityTag.m_128365_(TAG_STATS, (Tag)statTag);
        data.m_128365_(ability, (Tag)abilityTag);
        RelicItem.setAbilitiesData(stack, data);
    }

    public static int getAbilityPoints(ItemStack stack, String ability) {
        CompoundTag tag = RelicItem.getAbilityTag(stack, ability);
        if (tag.m_128456_()) {
            return 0;
        }
        return tag.m_128451_(TAG_POINTS);
    }

    public static void setAbilityPoints(ItemStack stack, String ability, int amount) {
        RelicItem.getAbilityTag(stack, ability).m_128405_(TAG_POINTS, amount);
    }

    public static void addAbilityPoints(ItemStack stack, String ability, int amount) {
        RelicItem.getAbilityTag(stack, ability).m_128405_(TAG_POINTS, Math.max(0, RelicItem.getAbilityPoints(stack, ability) + amount));
    }

    public static void setAbilitiesData(ItemStack stack, CompoundTag nbt) {
        stack.m_41784_().m_128365_(TAG_ABILITIES, (Tag)nbt);
    }

    public static boolean canUseAbility(ItemStack stack, String ability) {
        RelicAbilityEntry entry = RelicItem.getAbilityEntryData(stack, ability);
        return entry != null && RelicItem.getLevel(stack) >= entry.getRequiredLevel();
    }

    public static boolean randomizeStats(ItemStack stack, String ability) {
        RelicAbilityEntry entry = RelicItem.getAbilityEntryData(stack, ability);
        if (entry == null) {
            return false;
        }
        for (Map.Entry<String, RelicAbilityStat> stats : entry.stats.entrySet()) {
            RelicAbilityStat stat = stats.getValue();
            double result = MathUtils.round(MathUtils.randomBetween(new Random(), (Double)stat.getInitialValue().first(), (Double)stat.getInitialValue().second()), 3);
            RelicItem.setAbilityValue(stack, ability, stats.getKey(), result);
        }
        return true;
    }

    public static int getUpgradeRequiredExperience(ItemStack stack, String ability) {
        RelicAbilityEntry entry = RelicItem.getAbilityEntryData(stack, ability);
        if (entry == null) {
            return 0;
        }
        int count = entry.getStats().size();
        if (count == 0) {
            return 0;
        }
        return (RelicItem.getAbilityPoints(stack, ability) + 1) * entry.getRequiredPoints() * count * 15;
    }

    public static boolean isAbilityMaxLevel(ItemStack stack, String ability) {
        RelicAbilityEntry entry = RelicItem.getAbilityEntryData(stack, ability);
        if (entry == null) {
            return false;
        }
        return entry.getStats().size() == 0 || RelicItem.getAbilityPoints(stack, ability) >= (entry.getMaxLevel() == -1 ? RelicItem.getLevelingData(stack).getMaxLevel() / entry.getRequiredPoints() : entry.getMaxLevel());
    }

    public static boolean mayUpgrade(ItemStack stack, String ability) {
        RelicAbilityEntry entry = RelicItem.getAbilityEntryData(stack, ability);
        if (entry == null) {
            return false;
        }
        return entry.getStats().size() > 0 && !RelicItem.isAbilityMaxLevel(stack, ability) && RelicItem.getPoints(stack) >= entry.getRequiredPoints() && RelicItem.canUseAbility(stack, ability);
    }

    public static boolean mayPlayerUpgrade(Player player, ItemStack stack, String ability) {
        return RelicItem.mayUpgrade(stack, ability) && player.f_36079_ >= RelicItem.getUpgradeRequiredExperience(stack, ability);
    }

    public static int getRerollRequiredExperience(ItemStack stack, String ability) {
        RelicAbilityEntry entry = RelicItem.getAbilityEntryData(stack, ability);
        int count = entry.getStats().size();
        if (count == 0) {
            return 0;
        }
        return 100 / count;
    }

    public static boolean mayReroll(ItemStack stack, String ability) {
        RelicAbilityEntry entry = RelicItem.getAbilityEntryData(stack, ability);
        if (entry == null) {
            return false;
        }
        return entry.getStats().size() > 0 && RelicItem.getRerollRequiredExperience(stack, ability) > 0 && RelicItem.canUseAbility(stack, ability);
    }

    public static boolean mayPlayerReroll(Player player, ItemStack stack, String ability) {
        return RelicItem.mayReroll(stack, ability) && player.f_36079_ >= RelicItem.getRerollRequiredExperience(stack, ability);
    }

    public static int getResetRequiredExperience(ItemStack stack, String ability) {
        return RelicItem.getAbilityPoints(stack, ability) * 50;
    }

    public static boolean mayReset(ItemStack stack, String ability) {
        return RelicItem.getResetRequiredExperience(stack, ability) > 0 && RelicItem.canUseAbility(stack, ability);
    }

    public static boolean mayPlayerReset(Player player, ItemStack stack, String ability) {
        RelicAbilityEntry entry = RelicItem.getAbilityEntryData(stack, ability);
        if (entry == null) {
            return false;
        }
        return entry.getStats().size() > 0 && RelicItem.mayReset(stack, ability) && player.f_36079_ >= RelicItem.getResetRequiredExperience(stack, ability);
    }

    @Nullable
    public static RelicLevelingData getLevelingData(ItemStack stack) {
        return RelicItem.getRelicData(stack).getLevelingData();
    }

    @Nullable
    public static RelicLevelingData getLevelingData(RelicItem relic) {
        return relic.getRelicData().getLevelingData();
    }

    public static CompoundTag getLevelingTag(ItemStack stack) {
        return NBTUtils.getCompound(stack, TAG_LEVELING, new CompoundTag());
    }

    public static void setLevelingTag(ItemStack stack, CompoundTag data) {
        NBTUtils.setCompound(stack, TAG_LEVELING, data);
    }

    public static int getPoints(ItemStack stack) {
        return RelicItem.getLevelingTag(stack).m_128451_(TAG_POINTS);
    }

    public static void setPoints(ItemStack stack, int level) {
        CompoundTag tag = RelicItem.getLevelingTag(stack);
        tag.m_128405_(TAG_POINTS, level);
        RelicItem.setLevelingTag(stack, tag);
    }

    public static void addPoints(ItemStack stack, int amount) {
        RelicItem.setPoints(stack, RelicItem.getPoints(stack) + amount);
    }

    public static int getLevel(ItemStack stack) {
        return RelicItem.getLevelingTag(stack).m_128451_(TAG_LEVEL);
    }

    public static void setLevel(ItemStack stack, int level) {
        CompoundTag tag = RelicItem.getLevelingTag(stack);
        tag.m_128405_(TAG_LEVEL, Math.min(((RelicItem)stack.m_41720_()).getRelicData().getLevelingData().getMaxLevel(), level));
        RelicItem.setLevelingTag(stack, tag);
    }

    public static void addLevel(ItemStack stack, int amount) {
        RelicItem.addPoints(stack, amount);
        RelicItem.setLevel(stack, RelicItem.getLevel(stack) + amount);
    }

    public static int getExperience(ItemStack stack) {
        return RelicItem.getLevelingTag(stack).m_128451_(TAG_EXPERIENCE);
    }

    public static void setExperience(ItemStack stack, int experience) {
        CompoundTag data = RelicItem.getLevelingTag(stack);
        int level = RelicItem.getLevel(stack);
        int requiredExp = RelicItem.getExperienceBetweenLevels(stack, level, level + 1);
        if (experience >= requiredExp) {
            int sumExp = RelicItem.getTotalExperienceForLevel(stack, level) + experience;
            int resultLevel = RelicItem.getLevelFromExperience(stack, sumExp);
            data.m_128405_(TAG_EXPERIENCE, sumExp - RelicItem.getTotalExperienceForLevel(stack, resultLevel));
            RelicItem.setLevelingTag(stack, data);
            RelicItem.addPoints(stack, resultLevel - level);
            RelicItem.setLevel(stack, resultLevel);
        } else {
            data.m_128405_(TAG_EXPERIENCE, experience);
            RelicItem.setLevelingTag(stack, data);
        }
    }

    public static void addExperience(ItemStack stack, int amount) {
        ExperienceAddEvent event = new ExperienceAddEvent(null, stack, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            RelicItem.setExperience(stack, RelicItem.getExperience(stack) + event.getAmount());
        }
    }

    public static void addExperience(Entity entity, ItemStack stack, int amount) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ExperienceAddEvent event = new ExperienceAddEvent(player, stack, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            RelicItem.setExperience(stack, RelicItem.getExperience(stack) + event.getAmount());
        }
    }

    public static int getExperienceLeftForLevel(ItemStack stack, int level) {
        int currentLevel = RelicItem.getLevel(stack);
        return RelicItem.getExperienceBetweenLevels(stack, currentLevel, level) - RelicItem.getExperience(stack);
    }

    public static int getExperienceBetweenLevels(ItemStack stack, int from, int to) {
        return RelicItem.getTotalExperienceForLevel(stack, to) - RelicItem.getTotalExperienceForLevel(stack, from);
    }

    public static int getTotalExperienceForLevel(ItemStack stack, int level) {
        if (level <= 0) {
            return 0;
        }
        RelicLevelingData data = ((RelicItem)stack.m_41720_()).getRelicData().getLevelingData();
        int result = data.getInitialCost();
        for (int i = 1; i < level; ++i) {
            result += data.getInitialCost() + data.getStep() * i;
        }
        return result;
    }

    public static int getLevelFromExperience(ItemStack stack, int experience) {
        int amount;
        int result = 0;
        while ((amount = RelicItem.getTotalExperienceForLevel(stack, ++result)) <= experience) {
        }
        return result - 1;
    }

    public static int getStatQuality(ItemStack stack, String ability, String stat) {
        RelicAbilityStat statData = RelicItem.getAbilityStat(stack, ability, stat);
        if (statData == null) {
            return 0;
        }
        Function<Double, ? extends Number> format = statData.getFormatValue();
        double initial = format.apply(RelicItem.getAbilityInitialValue(stack, ability, stat)).doubleValue();
        double min = format.apply((Double)statData.getInitialValue().first()).doubleValue();
        double max = format.apply((Double)statData.getInitialValue().second()).doubleValue();
        return (int)Math.round((initial - min) / ((max - min) / 10.0));
    }

    public static int getAbilityQuality(ItemStack stack, String ability) {
        RelicAbilityEntry entry = RelicItem.getAbilityEntryData(stack, ability);
        Map<String, RelicAbilityStat> stats = entry.getStats();
        int sum = 0;
        for (String stat : stats.keySet()) {
            sum += RelicItem.getStatQuality(stack, ability, stat);
        }
        return sum / stats.size();
    }

    public static int getRelicQuality(ItemStack stack) {
        RelicAbilityData data = RelicItem.getAbilityData(stack);
        Map<String, RelicAbilityEntry> abilities = data.getAbilities();
        int sum = 0;
        for (String ability : abilities.keySet()) {
            sum += RelicItem.getAbilityQuality(stack, ability);
        }
        return sum / abilities.size();
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$1(Multimap modifiers, UUID uuid, Pair slot) {
        CuriosApi.getCuriosHelper().addSlotModifier(modifiers, (String)slot.getLeft(), uuid, (double)((Integer)slot.getRight()).intValue(), AttributeModifier.Operation.ADDITION);
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(Multimap modifiers, UUID uuid, ItemStack stack, RelicAttributeModifier.Modifier attribute) {
        modifiers.put((Object)attribute.getAttribute(), (Object)new AttributeModifier(uuid, stack.m_41720_().getRegistryName().m_135815_() + "_" + attribute.getAttribute().getRegistryName().m_135815_(), (double)attribute.getMultiplier(), attribute.getOperation()));
    }
}

