/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.belt;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.SlotContext;

public class DrownedBeltItem
extends RelicItem {
    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("slots", RelicAbilityEntry.builder().requiredPoints(2).stat("talisman", RelicAbilityStat.builder().initialValue(0.0, 2.0).upgradeModifier(RelicAbilityStat.Operation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).ability("anchor", RelicAbilityEntry.builder().stat("slowness", RelicAbilityStat.builder().initialValue(0.25, 0.5).upgradeModifier(RelicAbilityStat.Operation.ADD, -0.05).formatValue(value -> (int)(MathUtils.round(value, 2) * 100.0)).build()).stat("sinking", RelicAbilityStat.builder().initialValue(3.0, 5.0).upgradeModifier(RelicAbilityStat.Operation.ADD, -0.1).formatValue(value -> (int)(MathUtils.round(value, 2) * 100.0)).build()).build()).ability("pressure", RelicAbilityEntry.builder().stat("damage", RelicAbilityStat.builder().initialValue(1.25, 2.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)(MathUtils.round(value, 2) * 100.0)).build()).build()).ability("riptide", RelicAbilityEntry.builder().stat("cooldown", RelicAbilityStat.builder().initialValue(5.0, 10.0).upgradeModifier(RelicAbilityStat.Operation.ADD, -0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#7889b8", "#25374e").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_204029_(FluidTags.f_13131_) && !player.m_20096_()) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), (float)DrownedBeltItem.getAbilityValue(stack, "anchor", "sinking"), AttributeModifier.Operation.MULTIPLY_TOTAL);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return RelicSlotModifier.builder().entry((Pair<String, Integer>)Pair.of((Object)"talisman", (Object)((int)Math.round(DrownedBeltItem.getAbilityValue(stack, "slots", "talisman"))))).build();
    }

    @Override
    public RelicAttributeModifier getAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier((Attribute)ForgeMod.SWIM_SPEED.get(), (float)(-DrownedBeltItem.getAbilityValue(stack, "anchor", "slowness")))).build();
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Player player;
            Entity entity = event.getSource().m_7639_();
            if (!(entity instanceof Player && (player = (Player)entity).m_5842_() && event.getEntityLiving().m_5842_())) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.DROWNED_BELT.get());
            if (stack.m_41619_()) {
                return;
            }
            event.setAmount((float)((double)event.getAmount() * RelicItem.getAbilityValue(stack, "pressure", "damage")));
        }

        @SubscribeEvent
        public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
            block3: {
                block2: {
                    ItemStack stack = event.getItem();
                    LivingEntity livingEntity = event.getEntityLiving();
                    if (!(livingEntity instanceof Player)) break block2;
                    Player player = (Player)livingEntity;
                    if (stack.m_41720_() == Items.f_42713_ && player.m_36335_().m_41519_(stack.m_41720_())) break block3;
                }
                return;
            }
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onItemUseFinish(LivingEntityUseItemEvent.Stop event) {
            Player player;
            ItemStack stack;
            block6: {
                block5: {
                    stack = event.getItem();
                    LivingEntity livingEntity = event.getEntityLiving();
                    if (!(livingEntity instanceof Player)) break block5;
                    player = (Player)livingEntity;
                    if (stack.m_41720_() == Items.f_42713_) break block6;
                }
                return;
            }
            ItemStack relic = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.DROWNED_BELT.get());
            if (relic.m_41619_()) {
                return;
            }
            int duration = stack.m_41720_().m_8105_(stack) - event.getDuration();
            int enchantment = EnchantmentHelper.m_44932_((ItemStack)stack);
            if (duration < 10 || enchantment <= 0) {
                return;
            }
            RelicItem.addExperience((Entity)player, relic, enchantment);
            player.m_36335_().m_41524_(stack.m_41720_(), (int)Math.round(RelicItem.getAbilityValue(relic, "riptide", "cooldown") * (double)enchantment * 20.0));
        }
    }
}

