/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class AmphibianBootItem
extends RelicItem {
    private static final String TAG_DURATION = "duration";

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("swimming", RelicAbilityEntry.builder().stat("speed", RelicAbilityStat.builder().initialValue(0.005, 0.01).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.25).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0 * 20.0)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#ff6900", "#ff2e00").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block11: {
            block10: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block10;
                player = (Player)livingEntity;
                if (!DurabilityUtils.isBroken(stack)) break block11;
            }
            return;
        }
        int duration = NBTUtils.getInt(stack, TAG_DURATION, 0);
        if (player.m_6069_()) {
            if (player.f_19797_ % 20 == 0) {
                AmphibianBootItem.addExperience((Entity)player, stack, 1);
            }
            if (duration < 100) {
                NBTUtils.setInt(stack, TAG_DURATION, duration + 1);
            }
        } else if (duration > 0) {
            NBTUtils.setInt(stack, TAG_DURATION, --duration);
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.SWIM_SPEED.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (duration > 0) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.SWIM_SPEED.get(), (float)((double)duration * AmphibianBootItem.getAbilityValue(stack, "swimming", "speed")), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.m_41720_() == newStack.m_41720_()) {
            return;
        }
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Attribute)ForgeMod.SWIM_SPEED.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
    }
}

