/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.api.events.common.FluidCollisionEvent;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class AquaWalkerItem
extends RelicItem {
    public static final String TAG_DRENCH = "drench";

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("walking", RelicAbilityEntry.builder().stat("time", RelicAbilityStat.builder().initialValue(30.0, 60.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#ff6900", "#ff2e00").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        int drench;
        block5: {
            block4: {
                drench = NBTUtils.getInt(stack, TAG_DRENCH, 0);
                LivingEntity livingEntity = slotContext.getWearer();
                if (!(livingEntity instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (player.f_19797_ % 20 == 0) break block5;
            }
            return;
        }
        if (drench > 0 && !player.m_20069_() && !player.f_19853_.m_6425_(player.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_)) {
            NBTUtils.setInt(stack, TAG_DRENCH, --drench);
        }
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onFluidCollide(FluidCollisionEvent event) {
            Player player;
            int drench;
            ItemStack stack;
            block6: {
                block5: {
                    stack = EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.AQUA_WALKER.get());
                    drench = NBTUtils.getInt(stack, AquaWalkerItem.TAG_DRENCH, 0);
                    LivingEntity livingEntity = event.getEntityLiving();
                    if (!(livingEntity instanceof Player)) break block5;
                    player = (Player)livingEntity;
                    if (!stack.m_41619_() && !((double)drench > RelicItem.getAbilityValue(stack, "walking", "time")) && event.getFluid().m_205070_(FluidTags.f_13131_) && !player.m_6144_()) break block6;
                }
                return;
            }
            if (player.f_19797_ % 20 == 0) {
                NBTUtils.setInt(stack, AquaWalkerItem.TAG_DRENCH, ++drench);
                if (drench % 5 == 0) {
                    RelicItem.addExperience((Entity)player, stack, 1);
                }
            }
            event.setCanceled(true);
        }
    }
}

