/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.api.events.common.FluidCollisionEvent;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class MagmaWalkerItem
extends RelicItem {
    public static final String TAG_HEAT = "heat";

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("pace", RelicAbilityEntry.builder().stat(TAG_HEAT, RelicAbilityStat.builder().initialValue(20.0, 50.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#dc41ff", "#832698").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        int heat;
        block7: {
            block6: {
                heat = NBTUtils.getInt(stack, TAG_HEAT, 0);
                LivingEntity livingEntity = slotContext.getWearer();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                if (player.f_19797_ % 20 == 0) break block7;
            }
            return;
        }
        if (heat > 0) {
            Level level;
            if ((double)heat > MagmaWalkerItem.getAbilityValue(stack, "pace", TAG_HEAT)) {
                player.m_6469_(DamageSource.f_19309_, (float)(1.0 + ((double)heat - MagmaWalkerItem.getAbilityValue(stack, "pace", TAG_HEAT)) / 10.0));
            }
            if (!(level = player.f_19853_).m_6425_(player.m_142538_().m_7495_()).m_205070_(FluidTags.f_13132_) && !level.m_6425_(player.m_142538_()).m_205070_(FluidTags.f_13132_)) {
                NBTUtils.setInt(stack, TAG_HEAT, --heat);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.MAGMA_WALKER.get());
            if (!stack.m_41619_() && event.getSource() == DamageSource.f_19309_ && (double)NBTUtils.getInt(stack, MagmaWalkerItem.TAG_HEAT, 0) <= RelicItem.getAbilityValue(stack, "pace", MagmaWalkerItem.TAG_HEAT)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onFluidCollide(FluidCollisionEvent event) {
            Player player;
            ItemStack stack;
            block6: {
                block5: {
                    stack = EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.MAGMA_WALKER.get());
                    LivingEntity livingEntity = event.getEntityLiving();
                    if (!(livingEntity instanceof Player)) break block5;
                    player = (Player)livingEntity;
                    if (!stack.m_41619_() && event.getFluid().m_205070_(FluidTags.f_13132_) && !player.m_6144_()) break block6;
                }
                return;
            }
            if (player.f_19797_ % 20 == 0) {
                int heat = NBTUtils.getInt(stack, MagmaWalkerItem.TAG_HEAT, 0);
                NBTUtils.setInt(stack, MagmaWalkerItem.TAG_HEAT, ++heat);
                if (heat % 5 == 0) {
                    RelicItem.addExperience((Entity)player, stack, 1);
                }
            }
            event.setCanceled(true);
        }
    }
}

