/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class EnderHandItem
extends RelicItem {
    public static final String TAG_TIME = "time";
    public static final String TAG_TARGET = "target";

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("neutrality", RelicAbilityEntry.builder().build()).ability("swap", RelicAbilityEntry.builder().stat("distance", RelicAbilityStat.builder().initialValue(16.0, 32.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#eed551", "#dcbe1d").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block19: {
            block18: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block18;
                player = (Player)livingEntity;
                if (!DurabilityUtils.isBroken(stack) && !player.m_36335_().m_41519_(stack.m_41720_())) break block19;
            }
            return;
        }
        Level level = player.m_183503_();
        String uuid = NBTUtils.getString(stack, TAG_TARGET, "");
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        if (time > 0) {
            level.m_5594_(null, player.m_142538_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.5f, 1.0f + (float)time * 0.025f);
        }
        if (player.m_6144_()) {
            if (uuid.isEmpty()) {
                Entity entity2;
                EntityHitResult result = EntityUtils.rayTraceEntity((Entity)player, entity -> !entity.m_5833_() && entity.m_6087_(), EnderHandItem.getAbilityValue(stack, "swap", "distance"));
                if (result != null && (entity2 = result.m_82443_()) instanceof LivingEntity) {
                    LivingEntity entity3 = (LivingEntity)entity2;
                    uuid = entity3.m_20149_();
                    NBTUtils.setString(stack, TAG_TARGET, uuid);
                }
            } else if (time < 20) {
                ++time;
                if (!level.m_5776_()) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123799_, player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() * 0.5f), player.m_20189_(), time, (double)(player.m_20205_() * 0.5f), (double)(player.m_20206_() * 0.5f), (double)(player.m_20205_() * 0.5f), (double)0.025f);
                }
                NBTUtils.setInt(stack, TAG_TIME, time);
            } else if (!level.m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entity4 = serverLevel.m_8791_(UUID.fromString(uuid));
                if (entity4 == null) {
                    NBTUtils.setString(stack, TAG_TARGET, "");
                    NBTUtils.setInt(stack, TAG_TIME, 0);
                    return;
                }
                Vec3 targetPos = player.m_20182_();
                Vec3 currentPos = entity4.m_20182_();
                player.m_6021_(currentPos.m_7096_(), currentPos.m_7098_(), currentPos.m_7094_());
                level.m_6263_(null, currentPos.m_7096_(), currentPos.m_7098_(), currentPos.m_7094_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity4.m_6021_(targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_());
                level.m_6263_(null, targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                NBTUtils.setString(stack, TAG_TARGET, "");
                NBTUtils.setInt(stack, TAG_TIME, 0);
                int distance = (int)Math.round(targetPos.m_82554_(currentPos));
                EnderHandItem.addExperience((Entity)player, stack, 1 + Math.round((float)distance * 0.1f));
                player.m_36335_().m_41524_((Item)this, 20);
                Vec3 finalVec = targetPos.m_82549_(currentPos.m_82546_(targetPos).m_82541_().m_82542_((double)distance, (double)distance, (double)distance));
                distance = (int)Math.round(targetPos.m_82554_(finalVec)) * 5;
                for (int i = 0; i < distance; ++i) {
                    float x = (float)((finalVec.f_82479_ - targetPos.f_82479_) * (double)i / (double)distance + targetPos.f_82479_);
                    float y = (float)((finalVec.f_82480_ - targetPos.f_82480_) * (double)i / (double)distance + targetPos.f_82480_ + (double)(player.m_20206_() / 2.0f));
                    float z = (float)((finalVec.f_82481_ - targetPos.f_82481_) * (double)i / (double)distance + targetPos.f_82481_);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, (double)x, (double)y, (double)z, 1, 0.0, 0.0, 0.0, (double)0.005f);
                }
            }
        } else if (time > 0) {
            NBTUtils.setInt(stack, TAG_TIME, --time);
        } else {
            NBTUtils.setString(stack, TAG_TARGET, "");
        }
    }

    @Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void onFOVUpdate(FOVModifierEvent event) {
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.ENDER_HAND.get());
            if (stack.m_41619_()) {
                return;
            }
            int time = NBTUtils.getInt(stack, EnderHandItem.TAG_TIME, 0);
            if (time > 0) {
                event.setNewfov(event.getNewfov() - (float)time / 32.0f);
            }
        }
    }
}

