/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class RageGloveItem
extends RelicItem {
    public static final String TAG_STACKS = "stacks";
    public static final String TAG_TIME = "time";

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("rage", RelicAbilityEntry.builder().stat("incoming_damage", RelicAbilityStat.builder().initialValue(0.02, 0.05).upgradeModifier(RelicAbilityStat.Operation.ADD, -0.0015).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).stat("dealt_damage", RelicAbilityStat.builder().initialValue(0.025, 0.075).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).stat("movement_speed", RelicAbilityStat.builder().initialValue(0.01, 0.025).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).stat("attack_speed", RelicAbilityStat.builder().initialValue(0.005, 0.01).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#eed551", "#dcbe1d").build()).build();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        block7: {
            block6: {
                if (!(entity instanceof Player)) break block6;
                player = (Player)entity;
                if (player.f_19797_ % 20 == 0 && !DurabilityUtils.isBroken(stack)) break block7;
            }
            return;
        }
        int stacks = NBTUtils.getInt(stack, TAG_STACKS, 0);
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        if (stacks <= 0) {
            return;
        }
        EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22283_, (float)((double)stacks * RageGloveItem.getAbilityValue(stack, "rage", "attack_speed")), AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22279_, (float)((double)stacks * RageGloveItem.getAbilityValue(stack, "rage", "movement_speed")), AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (time > 0) {
            NBTUtils.setInt(stack, TAG_TIME, --time);
        } else {
            NBTUtils.setInt(stack, TAG_STACKS, 0);
            RageGloveItem.addExperience((Entity)player, stack, (int)Math.floor((float)stacks / 3.0f));
            EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class RageGloveEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Entity source = event.getSource().m_7639_();
            if (source instanceof Player) {
                Player player = (Player)source;
                if (!(event.getSource().m_7640_() instanceof Player)) {
                    return;
                }
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.RAGE_GLOVE.get());
                if (stack.m_41619_()) {
                    return;
                }
                int stacks = NBTUtils.getInt(stack, RageGloveItem.TAG_STACKS, 0);
                NBTUtils.setInt(stack, RageGloveItem.TAG_STACKS, ++stacks);
                NBTUtils.setInt(stack, RageGloveItem.TAG_TIME, 3);
                event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * ((double)stacks * RelicItem.getAbilityValue(stack, "rage", "dealt_damage"))));
            } else {
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.RAGE_GLOVE.get());
                if (stack.m_41619_()) {
                    return;
                }
                int stacks = NBTUtils.getInt(stack, RageGloveItem.TAG_STACKS, 0);
                if (stacks <= 0) {
                    return;
                }
                event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * ((double)stacks * RelicItem.getAbilityValue(stack, "rage", "incoming_damage"))));
            }
        }
    }
}

