/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class WoolMittenItem
extends RelicItem {
    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("mold", RelicAbilityEntry.builder().stat("size", RelicAbilityStat.builder().initialValue(12.0, 32.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat("damage", RelicAbilityStat.builder().initialValue(0.05, 0.25).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 2)).build()).stat("stun", RelicAbilityStat.builder().initialValue(0.025, 0.05).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 3)).build()).stat("freeze", RelicAbilityStat.builder().initialValue(1.0, 2.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.3).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#eed551", "#dcbe1d").build()).build();
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
            int layers;
            BlockPos pos;
            Player player = event.getPlayer();
            ItemStack relic = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.WOOL_MITTEN.get());
            if (!player.m_21205_().m_41619_() || !player.m_21206_().m_41619_() || relic.m_41619_()) {
                return;
            }
            Level level = player.m_183503_();
            BlockState state = level.m_8055_(pos = event.getPos());
            Block block = state.m_60734_();
            int n = block == Blocks.f_50125_ ? (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) : (layers = block == Blocks.f_50127_ ? 9 : 0);
            if (layers == 0) {
                return;
            }
            Inventory inventory = player.m_150109_();
            int size = (int)Math.round(RelicItem.getAbilityValue(relic, "mold", "size"));
            Optional<Integer> slot = EntityUtils.getSlotsWithItem(player, (Item)ItemRegistry.SOLID_SNOWBALL.get()).stream().filter(id -> NBTUtils.getInt(inventory.m_8020_(id.intValue()), "snow", 0) < size).max(Comparator.comparingInt(s -> NBTUtils.getInt((ItemStack)inventory.f_35974_.get(s.intValue()), "snow", 0)));
            if (slot.isEmpty()) {
                if (inventory.m_36054_(new ItemStack((ItemLike)ItemRegistry.SOLID_SNOWBALL.get()))) {
                    slot = EntityUtils.getSlotsWithItem(player, (Item)ItemRegistry.SOLID_SNOWBALL.get()).stream().findFirst();
                    if (slot.isEmpty()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            ItemStack stack = inventory.m_8020_(slot.get().intValue());
            level.m_46961_(pos, false);
            int snow = NBTUtils.getInt(stack, "snow", 0);
            NBTUtils.setInt(stack, "snow", Math.min(snow + layers, size));
        }
    }
}

