/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class JellyfishNecklaceItem
extends RelicItem {
    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("unsinkable", RelicAbilityEntry.builder().build()).ability("shock", RelicAbilityEntry.builder().stat("damage", RelicAbilityStat.builder().initialValue(0.5, 2.5).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability("paralysis", RelicAbilityEntry.builder().requiredLevel(5).stat("duration", RelicAbilityStat.builder().initialValue(0.5, 1.5).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#dc41ff", "#832698").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_204029_(FluidTags.f_13131_)) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), -1.0f, AttributeModifier.Operation.MULTIPLY_TOTAL);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        Level level = player.m_20193_();
        for (LivingEntity entity : level.m_45976_(LivingEntity.class, player.m_142469_())) {
            if (entity == player || !entity.m_6469_(DamageSource.m_19344_((Player)player), (float)JellyfishNecklaceItem.getAbilityValue(stack, "shock", "damage"))) continue;
            JellyfishNecklaceItem.addExperience((Entity)player, stack, 1);
            if (!JellyfishNecklaceItem.canUseAbility(stack, "paralysis")) continue;
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.PARALYSIS.get(), (int)Math.round(JellyfishNecklaceItem.getAbilityValue(stack, "paralysis", "duration") * 20.0), 0));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
    }
}

