/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.entities.StalactiteEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class ReflectionNecklaceItem
extends RelicItem {
    public static final String TAG_CHARGE = "charge";
    public static final String TAG_TIME = "time";

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("explode", RelicAbilityEntry.builder().stat("capacity", RelicAbilityStat.builder().initialValue(20.0, 60.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.35).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#dc41ff", "#832698").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block10: {
            block9: {
                LivingEntity livingEntity;
                if (DurabilityUtils.isBroken(stack) || !((livingEntity = slotContext.entity()) instanceof Player)) break block9;
                player = (Player)livingEntity;
                if (player.f_19797_ % 20 == 0) break block10;
            }
            return;
        }
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        double charge = NBTUtils.getDouble(stack, TAG_CHARGE, 0.0);
        if (time > 0 && charge < ReflectionNecklaceItem.getAbilityValue(stack, "explode", "capacity")) {
            NBTUtils.setInt(stack, TAG_TIME, --time);
        } else if (charge > 0.0) {
            Level level = player.m_183503_();
            Random random = player.m_21187_();
            float size = (float)(Math.log(charge) * (double)0.6f);
            float speed = (float)((double)0.35f + charge * (double)0.001f);
            for (float i = -size; i <= size; i += 1.0f) {
                for (float j = -size; j <= size; j += 1.0f) {
                    for (float k = -size; k <= size; k += 1.0f) {
                        double d3 = (double)j + (random.nextDouble() - random.nextDouble());
                        double d4 = (double)i + (random.nextDouble() - random.nextDouble());
                        double d5 = (double)k + (random.nextDouble() - random.nextDouble());
                        double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / (double)speed + random.nextGaussian();
                        Vec3 motion = new Vec3(d3 / d6, d4 / d6, d5 / d6);
                        float mul = player.m_20206_() / 1.5f;
                        Vec3 pos = player.m_20182_().m_82520_(0.0, (double)mul, 0.0).m_82549_(motion.m_82541_().m_82542_((double)mul, (double)mul, (double)mul));
                        if (level.m_8055_(new BlockPos(pos)).m_60767_().m_76334_()) continue;
                        StalactiteEntity stalactite = new StalactiteEntity(level, (float)charge);
                        stalactite.m_5602_((Entity)player);
                        stalactite.m_146884_(pos);
                        stalactite.m_20256_(motion);
                        level.m_7967_((Entity)stalactite);
                    }
                }
            }
            ReflectionNecklaceItem.addExperience((Entity)player, stack, (int)Math.floor(charge * (double)0.05f));
            NBTUtils.setDouble(stack, TAG_CHARGE, 0.0);
            NBTUtils.setInt(stack, TAG_TIME, 0);
        }
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class ReflectionNecklaceServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            double capacity;
            if (!(event.getEntityLiving() instanceof Player)) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.REFLECTION_NECKLACE.get());
            if (stack.m_41619_()) {
                return;
            }
            double charge = NBTUtils.getDouble(stack, ReflectionNecklaceItem.TAG_CHARGE, 0.0);
            if (charge < (capacity = RelicItem.getAbilityValue(stack, "explode", "capacity"))) {
                NBTUtils.setDouble(stack, ReflectionNecklaceItem.TAG_CHARGE, Math.min(capacity, charge + (double)event.getAmount()));
                NBTUtils.setInt(stack, ReflectionNecklaceItem.TAG_TIME, 5);
            }
        }
    }
}

