/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.ring;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class CamouflageRingItem
extends RelicItem {
    private static final String TAG_TIME = "time";
    private static final String TAG_POS = "pos";

    public CamouflageRingItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("morph", RelicAbilityEntry.builder().build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#008cd7", "#0a3484").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = player.m_183503_();
        if (level.m_5776_()) {
            return;
        }
        Vec3 oldPos = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POS, ""));
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        if (oldPos == null) {
            oldPos = player.m_20182_();
            NBTUtils.setString(stack, TAG_POS, NBTUtils.writePosition(oldPos));
        }
        if (oldPos.m_82554_(player.m_20182_()) > (double)0.05f || player.m_6144_() || player.m_20159_() || player.m_6067_()) {
            if (time > 0) {
                NBTUtils.setInt(stack, TAG_TIME, 0);
                int requiredTime = 50;
                if (time > requiredTime) {
                    double difference = Math.ceil(player.m_20186_()) - player.m_20186_();
                    BlockPos pos = difference > 0.0 ? player.m_142538_() : player.m_142538_().m_7495_();
                    BlockState state = level.m_8055_(pos);
                    if (state.m_60795_()) {
                        state = level.m_8055_(player.m_20099_());
                    }
                    if (!state.m_60795_()) {
                        float scale = (float)(time - requiredTime) / ((float)requiredTime * 1.0f) * 0.25f;
                        ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.5f), (double)((float)pos.m_123343_() + 0.5f), Math.round(scale * 100.0f), (double)scale, (double)scale, (double)scale, (double)(scale * 0.1f));
                        level.m_5594_(null, pos, state.m_60827_().m_56775_(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
            NBTUtils.setString(stack, TAG_POS, NBTUtils.writePosition(player.m_20182_()));
            return;
        }
        if (time < 100) {
            NBTUtils.setInt(stack, TAG_TIME, ++time);
        }
    }

    @Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class CamouflageRingClientEvents {
        @SubscribeEvent
        public static void onEntityRender(RenderPlayerEvent.Pre event) {
            Player player = event.getPlayer();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.CAMOUFLAGE_RING.get());
            if (stack.m_41619_()) {
                return;
            }
            int requiredTime = 50;
            int time = NBTUtils.getInt(stack, CamouflageRingItem.TAG_TIME, 0);
            if (time <= requiredTime) {
                return;
            }
            double difference = Math.ceil(player.m_20186_()) - player.m_20186_();
            BlockPos pos = difference > 0.0 ? player.m_142538_() : player.m_142538_().m_7495_();
            Level level = player.m_183503_();
            BlockState state = level.m_8055_(pos);
            boolean isGiant = false;
            if (state.m_60795_()) {
                isGiant = true;
                state = level.m_8055_(player.m_20099_());
            }
            if (state.m_60795_() || state.m_60767_().m_76332_()) {
                return;
            }
            Minecraft MC = Minecraft.m_91087_();
            PoseStack poseStack = event.getPoseStack();
            BlockRenderDispatcher dispatcher = MC.m_91289_();
            float scale = (float)(time - requiredTime) / ((float)requiredTime * 1.0f);
            float offset = (1.0f - scale) / 2.0f;
            poseStack.m_85836_();
            double x = player.m_20185_();
            double z = player.m_20189_();
            poseStack.m_85837_(-(x - Math.ceil(x)) - 1.0 + (double)offset, isGiant ? -difference + (double)offset : difference + (double)offset, -(z - Math.ceil(z)) - 1.0 + (double)offset);
            poseStack.m_85841_(scale, scale, scale);
            for (RenderType type : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                ForgeHooksClient.setRenderType((RenderType)type);
                dispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)player.m_183503_(), dispatcher.m_110910_(state), state, pos.m_7494_(), poseStack, event.getMultiBufferSource().m_6299_(type), false, new Random(), state.m_60726_(pos), OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
            }
            ForgeHooksClient.setRenderType(null);
            poseStack.m_85849_();
            if (time < 100) {
                scale = offset * 2.0f;
                poseStack.m_85841_(scale, scale, scale);
            } else {
                event.setCanceled(true);
                poseStack.m_85841_(0.0f, 0.0f, 0.0f);
            }
        }
    }
}

