/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.talisman;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.entities.SporeEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SporeSackItem
extends RelicItem {
    @Override
    public RelicData getRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("spore", RelicAbilityEntry.builder().requiredPoints(2).stat("amount", RelicAbilityStat.builder().initialValue(1.0, 1.0).upgradeModifier(RelicAbilityStat.Operation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat("resize", RelicAbilityStat.builder().initialValue(0.01, 0.025).upgradeModifier(RelicAbilityStat.Operation.ADD, -0.001).formatValue(value -> (int)(MathUtils.round(value, 2) * 100.0)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#ffe0d2", "#9c756b").build()).build();
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity livingEntity = event.getEntityLiving();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.SPORE_SACK.get());
            if (stack.m_41619_()) {
                return;
            }
            Level level = player.m_183503_();
            Random random = player.m_21187_();
            for (int i = 0; i < random.nextInt((int)Math.round(RelicItem.getAbilityValue(stack, "spore", "amount"))) + 1; ++i) {
                float speed = 0.25f + random.nextFloat() * 0.2f;
                Vec3 motion = new Vec3((double)(MathUtils.randomFloat(random) * speed), (double)speed, (double)(MathUtils.randomFloat(random) * speed));
                float mul = player.m_20206_() / 1.5f;
                Vec3 pos = player.m_20182_().m_82520_(0.0, (double)mul, 0.0).m_82549_(motion.m_82541_().m_82542_((double)mul, (double)mul, (double)mul));
                SporeEntity spore = new SporeEntity(level);
                spore.m_146884_(pos);
                spore.setStack(stack);
                spore.m_5602_((Entity)player);
                spore.m_20256_(motion);
                level.m_7967_((Entity)spore);
            }
        }
    }
}

