/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.api.events.utils.EventDispatcher;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class MixinEntity {
    @ModifyVariable(method={"move"}, ordinal=1, index=3, name={"vec32"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 fluidCollision(Vec3 original) {
        MixinEntity mixinEntity = this;
        if (!(mixinEntity instanceof LivingEntity)) {
            return original;
        }
        LivingEntity entity = (LivingEntity)mixinEntity;
        if (original.f_82480_ > 0.0 || MixinEntity.isTouchingFluid(entity, entity.m_142469_().m_82406_(0.001))) {
            return original;
        }
        HashMap points = new HashMap();
        Double highestDistance = null;
        AABB box = entity.m_142469_().m_82383_(original);
        points.put(new Vec3(box.f_82288_, box.f_82289_, box.f_82290_), null);
        points.put(new Vec3(box.f_82288_, box.f_82289_, box.f_82293_), null);
        points.put(new Vec3(box.f_82291_, box.f_82289_, box.f_82290_), null);
        points.put(new Vec3(box.f_82291_, box.f_82289_, box.f_82293_), null);
        boolean cancelled = false;
        double fluidStepHeight = entity.m_20096_() ? (double)Math.max(1.0f, entity.f_19793_) : 0.0;
        block0: for (Map.Entry entry : points.entrySet()) {
            int i = 0;
            while (true) {
                BlockPos landingPos = new BlockPos((Vec3)entry.getKey()).m_142022_(0.0, fluidStepHeight - (double)i, 0.0);
                FluidState landingState = entity.m_20193_().m_6425_(landingPos);
                double distanceToFluidSurface = (double)((float)landingPos.m_123342_() + landingState.m_76182_()) - entity.m_20186_();
                if (distanceToFluidSurface < original.f_82480_ || distanceToFluidSurface > fluidStepHeight) continue block0;
                if (!landingState.m_76178_() && (cancelled || EventDispatcher.onFluidCollision(entity, landingState))) {
                    entry.setValue(distanceToFluidSurface);
                    cancelled = true;
                    continue block0;
                }
                ++i;
            }
        }
        for (Map.Entry entry : points.entrySet()) {
            if (highestDistance != null && (entry.getValue() == null || !((Double)entry.getValue() > highestDistance))) continue;
            highestDistance = (Double)entry.getValue();
        }
        if (highestDistance == null) {
            return original;
        }
        Vec3 finalDisplacement = new Vec3(original.f_82479_, highestDistance.doubleValue(), original.f_82481_);
        if (!MixinEntity.isTouchingFluid(entity, entity.m_142469_().m_82383_(finalDisplacement).m_82406_(0.001))) {
            entity.f_19789_ = 0.0f;
            entity.m_6853_(true);
            return finalDisplacement;
        }
        return original;
    }

    @Unique
    private static boolean isTouchingFluid(LivingEntity entity, AABB box) {
        int maxZ;
        Level world = entity.m_20193_();
        int minX = Mth.m_14107_((double)box.f_82288_);
        int maxX = Mth.m_14165_((double)box.f_82291_);
        int minY = Mth.m_14107_((double)box.f_82289_);
        int maxY = Mth.m_14165_((double)box.f_82292_);
        int minZ = Mth.m_14107_((double)box.f_82290_);
        if (!world.m_46812_(minX, minY, minZ, maxX, maxY, maxZ = Mth.m_14165_((double)box.f_82293_))) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    mutable.m_122178_(i, j, k);
                    FluidState fluidState = world.m_6425_((BlockPos)mutable);
                    if (fluidState.m_76178_() || !((double)(fluidState.m_76155_((BlockGetter)world, (BlockPos)mutable) + (float)j) >= box.f_82289_)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Inject(at={@At(value="RETURN")}, method={"isInWaterOrRain"}, cancellable=true)
    public void setWet(CallbackInfoReturnable<Boolean> info) {
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (!EntityUtils.findEquippedCurio(entity, (Item)ItemRegistry.DROWNED_BELT.get()).m_41619_()) {
            info.setReturnValue((Object)true);
        }
    }
}

