/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.api.events.utils.EventDispatcher;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketSyncEntityEffects;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class MixinLivingEntity {
    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    protected void preventTotemUse(DamageSource source, CallbackInfoReturnable<Boolean> info) {
        LivingEntity entity = (LivingEntity)this;
        if (!EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.DELAY_RING.get()).m_41619_()) {
            info.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"travel"}, index=8, ordinal=0, at=@At(value="STORE"))
    protected float setBlockFriction(float original) {
        LivingEntity entity = (LivingEntity)this;
        return EventDispatcher.onLivingSlipping(entity, entity.f_19853_.m_8055_(entity.m_20099_()), original);
    }

    @Inject(method={"isImmobile"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onAiStep(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_21023_((MobEffect)EffectRegistry.STUN.get())) {
            cir.setReturnValue((Object)true);
        }
        if (entity.m_21023_((MobEffect)EffectRegistry.PARALYSIS.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onEffectAdded"}, at={@At(value="TAIL")})
    protected void onEffectAdded(MobEffectInstance effect, Entity target, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.m_20193_();
        if (level.m_5776_()) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        effect.m_19555_(tag);
        NetworkHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new PacketSyncEntityEffects(entity.m_142049_(), tag, PacketSyncEntityEffects.Action.ADD));
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="TAIL")})
    protected void onEffectRemoved(MobEffectInstance effect, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.m_20193_();
        if (level.m_5776_()) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        effect.m_19555_(tag);
        NetworkHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new PacketSyncEntityEffects(entity.m_142049_(), tag, PacketSyncEntityEffects.Action.REMOVE));
    }

    @Inject(method={"canBeSeenByAnyone"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canBeSeenByAnyone(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_21023_((MobEffect)EffectRegistry.VANISHING.get())) {
            cir.setReturnValue((Object)false);
        }
    }
}

