/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketRelicTweak {
    private final BlockPos pos;
    private final String ability;
    private final Operation operation;

    public PacketRelicTweak(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.ability = buf.m_130277_();
        this.operation = (Operation)buf.m_130066_(Operation.class);
    }

    public PacketRelicTweak(BlockPos pos, String ability, Operation operation) {
        this.pos = pos;
        this.ability = ability;
        this.operation = operation;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.ability);
        buf.m_130068_((Enum)this.operation);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.f_19853_;
            BlockEntity patt1649$temp = world.m_7702_(this.pos);
            if (!(patt1649$temp instanceof ResearchingTableTile)) {
                return;
            }
            ResearchingTableTile tile = (ResearchingTableTile)patt1649$temp;
            ItemStack stack = tile.getStack();
            Item patt1800$temp = stack.m_41720_();
            if (!(patt1800$temp instanceof RelicItem)) {
                return;
            }
            RelicItem relic = (RelicItem)patt1800$temp;
            RelicAbilityData data = relic.getRelicData().getAbilityData();
            if (data == null) {
                return;
            }
            RelicAbilityEntry entry = data.getAbilities().get(this.ability);
            if (entry == null) {
                return;
            }
            switch (this.operation) {
                case INCREASE: {
                    if (!RelicItem.mayPlayerUpgrade((Player)player, stack, this.ability)) break;
                    player.m_6756_(-RelicItem.getUpgradeRequiredExperience(stack, this.ability));
                    RelicItem.setAbilityPoints(stack, this.ability, RelicItem.getAbilityPoints(stack, this.ability) + 1);
                    RelicItem.addPoints(stack, -entry.getRequiredPoints());
                    break;
                }
                case REROLL: {
                    if (!RelicItem.mayPlayerReroll((Player)player, stack, this.ability)) break;
                    player.m_6756_(-RelicItem.getRerollRequiredExperience(stack, this.ability));
                    RelicItem.randomizeStats(stack, this.ability);
                    break;
                }
                case RESET: {
                    if (!RelicItem.mayPlayerReset((Player)player, stack, this.ability)) break;
                    player.m_6756_(-RelicItem.getResetRequiredExperience(stack, this.ability));
                    RelicItem.addPoints(stack, RelicItem.getAbilityPoints(stack, this.ability) * entry.getRequiredPoints());
                    RelicItem.setAbilityPoints(stack, this.ability, 0);
                }
            }
            world.m_7260_(this.pos, world.m_8055_(this.pos), world.m_8055_(this.pos), 2);
        });
        return true;
    }

    public static enum Operation {
        RESET,
        INCREASE,
        REROLL;

    }
}

