/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class EntityUtils {
    public static void moveTowardsPosition(Entity entity, Vec3 targetPos, double speed) {
        Vec3 motion = targetPos.m_82546_(entity.m_20182_()).m_82541_().m_82490_(speed);
        entity.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
    }

    public static int getSlotWithItem(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (player.m_150109_().m_8020_(i).m_41720_() != item) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getSlotsWithItem(Player player, Item item) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (player.m_150109_().m_8020_(i).m_41720_() != item) continue;
            list.add(i);
            if (i != player.m_150109_().m_6643_()) continue;
            return list;
        }
        return list;
    }

    public static EntityHitResult rayTraceEntity(Entity shooter, Predicate<? super Entity> filter, double distance) {
        Level world = shooter.f_19853_;
        Vec3 startVec = shooter.m_20299_(1.0f);
        Vec3 endVec = shooter.m_20299_(1.0f).m_82549_(shooter.m_20252_(1.0f).m_82490_(distance));
        double d0 = distance * distance;
        Entity entity = null;
        Vec3 vector3d = null;
        for (Entity entity1 : world.m_6249_(shooter, shooter.m_142469_().m_82369_(shooter.m_20252_(1.0f).m_82490_(distance * distance)).m_82400_(1.0), filter)) {
            Vec3 vector3d1;
            double d1;
            AABB axisalignedbb = entity1.m_142469_().m_82400_((double)entity1.m_6143_());
            Optional optional = axisalignedbb.m_82371_(startVec, endVec);
            if (axisalignedbb.m_82390_(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.m_82557_(vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.m_20201_() == shooter.m_20201_() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vector3d);
    }

    private static String getAttributeName(ItemStack stack, Attribute attribute) {
        return stack.m_41720_().getRegistryName().m_135815_() + "_" + attribute.getRegistryName().m_135815_();
    }

    public static void applyAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, float value, AttributeModifier.Operation operation) {
        String name = EntityUtils.getAttributeName(stack, attribute);
        if (name.equals("")) {
            return;
        }
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        AttributeModifier modifier = new AttributeModifier(uuid, name, (double)value, operation);
        if (instance == null || instance.m_22109_(modifier)) {
            return;
        }
        instance.m_22118_(modifier);
    }

    public static void removeAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, AttributeModifier.Operation operation) {
        String name = EntityUtils.getAttributeName(stack, attribute);
        if (name.equals("")) {
            return;
        }
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        AttributeModifier modifier = new AttributeModifier(uuid, name, instance.m_22135_(), operation);
        if (!instance.m_22109_(modifier)) {
            return;
        }
        instance.m_22130_(modifier);
    }

    public static void resetAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, float value, AttributeModifier.Operation operation) {
        EntityUtils.removeAttribute(entity, stack, attribute, operation);
        EntityUtils.applyAttribute(entity, stack, attribute, value, operation);
    }

    public static ItemStack findEquippedCurio(Entity entity, Item item) {
        if (!(entity instanceof Player)) {
            return ItemStack.f_41583_;
        }
        Player player = (Player)entity;
        Optional optional = CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player);
        if (optional.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = (ItemStack)((ImmutableTriple)optional.get()).getRight();
        return DurabilityUtils.isBroken(stack) ? ItemStack.f_41583_ : stack;
    }
}

