/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class NBTUtils {
    public static void setBoolean(ItemStack stack, String tag, boolean value) {
        stack.m_41784_().m_128379_(tag, value);
    }

    public static void setInt(ItemStack stack, String tag, int value) {
        stack.m_41784_().m_128405_(tag, value);
    }

    public static void setLong(ItemStack stack, String tag, long value) {
        stack.m_41784_().m_128356_(tag, value);
    }

    public static void setFloat(ItemStack stack, String tag, float value) {
        stack.m_41784_().m_128350_(tag, value);
    }

    public static void setDouble(ItemStack stack, String tag, double value) {
        stack.m_41784_().m_128347_(tag, value);
    }

    public static void setString(ItemStack stack, String tag, String value) {
        stack.m_41784_().m_128359_(tag, value);
    }

    public static void setCompound(ItemStack stack, String tag, CompoundTag value) {
        stack.m_41784_().m_128365_(tag, (Tag)value);
    }

    public static void setList(ItemStack stack, String tag, List<?> list) {
        ListTag listTag = new ListTag();
        for (Object entry : list) {
            if (entry instanceof String) {
                String stringEntry = (String)entry;
                listTag.add((Object)StringTag.m_129297_((String)stringEntry));
                continue;
            }
            if (entry instanceof Integer) {
                Integer intEntry = (Integer)entry;
                listTag.add((Object)IntTag.m_128679_((int)intEntry));
                continue;
            }
            throw new NullPointerException("Wrong entry instance type!");
        }
        stack.m_41784_().m_128365_(tag, (Tag)listTag);
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.m_41783_().m_128471_(tag) : defaultValue;
    }

    public static int getInt(ItemStack stack, String tag, int defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.m_41783_().m_128451_(tag) : defaultValue;
    }

    public static long getLong(ItemStack stack, String tag, long defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.m_41783_().m_128454_(tag) : defaultValue;
    }

    public static float getFloat(ItemStack stack, String tag, float defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.m_41783_().m_128457_(tag) : defaultValue;
    }

    public static double getDouble(ItemStack stack, String tag, double defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.m_41783_().m_128459_(tag) : defaultValue;
    }

    public static String getString(ItemStack stack, String tag, String defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.m_41783_().m_128461_(tag) : defaultValue;
    }

    public static CompoundTag getCompound(ItemStack stack, String tag, CompoundTag defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.m_41783_().m_128469_(tag) : defaultValue;
    }

    public static ListTag getList(ItemStack stack, String tag) {
        return NBTUtils.safeCheck(stack, tag) ? stack.m_41783_().m_128437_(tag, 9) : new ListTag();
    }

    public static ListTag constructListTag(Object ... objects) {
        ListTag tag = new ListTag();
        for (Object object : objects) {
            tag.add((Object)StringTag.m_129297_((String)object.toString()));
        }
        return tag;
    }

    public static boolean safeCheck(ItemStack stack, String tag) {
        return !stack.m_41619_() && stack.m_41783_() != null && stack.m_41783_().m_128441_(tag);
    }

    public static void clearTag(ItemStack stack, String tag) {
        stack.m_41784_().m_128473_(tag);
    }

    public static String writePosition(Vec3 vec) {
        return MathUtils.round(vec.m_7096_(), 1) + "," + MathUtils.round(vec.m_7098_(), 1) + "," + MathUtils.round(vec.m_7094_(), 1);
    }

    public static String writeLevel(Level level) {
        return level.m_46472_().m_135782_().toString();
    }

    @Nullable
    public static Vec3 parsePosition(String value) {
        if (value != null && !value.equals("")) {
            String[] pos = value.split(",");
            return new Vec3(Double.parseDouble(pos[0]), Double.parseDouble(pos[1]), Double.parseDouble(pos[2]));
        }
        return null;
    }

    public static CompoundTag packBundledPosition(Vec3 pos, Level level) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("pos", NBTUtils.writePosition(pos));
        tag.m_128359_("level", NBTUtils.writeLevel(level));
        return tag;
    }

    @Nullable
    public static Pair<ServerLevel, Vec3> parseBundledPosition(Level world, CompoundTag tag) {
        ServerLevel level = NBTUtils.parseLevel(world, tag.m_128461_("level"));
        Vec3 vec = NBTUtils.parsePosition(tag.m_128461_("pos"));
        if (level == null || vec == null) {
            return null;
        }
        return Pair.of((Object)level, (Object)vec);
    }

    @Nullable
    public static ServerLevel parseLevel(Level world, String value) {
        return world.m_142572_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(value)));
    }
}

