/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.world;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RelicLootModifier
extends LootModifier {
    private static final Gson GSON = Deserializers.m_78799_().create();
    private final LootItem entry;
    private final LootItemFunction[] functions;

    public RelicLootModifier(LootItemCondition[] conditionsIn, LootItem entry, LootItemFunction[] functions) {
        super(conditionsIn);
        this.entry = entry;
        this.functions = functions;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        this.entry.m_6562_(context, generator -> generator.m_6941_(LootItemFunction.m_80724_((BiFunction)LootItemFunctions.m_80770_((BiFunction[])this.functions), generatedLoot::add, (LootContext)context), context));
        return generatedLoot;
    }

    @Mod.EventBusSubscriber(modid="relics", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandler {
        @SubscribeEvent
        public static void registerModifierSerializers(@Nonnull RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName(new ResourceLocation("relics", "relic_gen")));
        }
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<RelicLootModifier> {
        private Serializer() {
        }

        public RelicLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new RelicLootModifier(conditions, (LootItem)GSON.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)object, (String)"entry"), LootItem.class), object.has("functions") ? (LootItemFunction[])GSON.fromJson((JsonElement)GsonHelper.m_13933_((JsonObject)object, (String)"functions"), LootItemFunction[].class) : new LootItemFunction[]{});
        }

        public JsonObject write(RelicLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.add("entry", GSON.toJsonTree((Object)instance.entry, LootItem.class));
            object.add("functions", GSON.toJsonTree((Object)instance.functions, LootItemFunction[].class));
            return object;
        }
    }
}

