/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;

public class SyncSlotChangeErrorMessage {
    private final UpgradeSlotChangeResult slotChangeError;

    public SyncSlotChangeErrorMessage(UpgradeSlotChangeResult slotChangeError) {
        this.slotChangeError = slotChangeError;
    }

    public static void encode(SyncSlotChangeErrorMessage msg, FriendlyByteBuf packetBuffer) {
        SyncSlotChangeErrorMessage.writeSlotChangeResult(packetBuffer, msg.slotChangeError);
    }

    private static void writeSlotChangeResult(FriendlyByteBuf packetBuffer, UpgradeSlotChangeResult slotChangeResult) {
        packetBuffer.m_130083_(slotChangeResult.getErrorMessage().orElse(TextComponent.f_131282_));
        packetBuffer.m_130089_(slotChangeResult.getErrorUpgradeSlots().stream().mapToInt(i -> i).toArray());
        packetBuffer.m_130089_(slotChangeResult.getErrorInventorySlots().stream().mapToInt(i -> i).toArray());
        packetBuffer.m_130089_(slotChangeResult.getErrorInventoryParts().stream().mapToInt(i -> i).toArray());
    }

    public static SyncSlotChangeErrorMessage decode(FriendlyByteBuf packetBuffer) {
        return new SyncSlotChangeErrorMessage(new UpgradeSlotChangeResult.Fail(packetBuffer.m_130238_(), Arrays.stream(packetBuffer.m_130100_()).boxed().collect(Collectors.toSet()), Arrays.stream(packetBuffer.m_130100_()).boxed().collect(Collectors.toSet()), Arrays.stream(packetBuffer.m_130100_()).boxed().collect(Collectors.toSet())));
    }

    public static void onMessage(SyncSlotChangeErrorMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncSlotChangeErrorMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncSlotChangeErrorMessage msg) {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !((abstractContainerMenu = player.f_36096_) instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase menu = (StorageContainerMenuBase)abstractContainerMenu;
        menu.updateSlotChangeError(msg.slotChangeError);
    }
}

