/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.battery;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankClickMessage;

public class BatteryInventoryPart
extends UpgradeInventoryPartBase<BatteryUpgradeContainer> {
    private static final TextureBlitData TANK_BACKGROUND_TOP = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    private static final TextureBlitData TANK_BACKGROUND_MIDDLE = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    private static final TextureBlitData TANK_BACKGROUND_BOTTOM = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    private static final TextureBlitData OVERLAY = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 56), new Dimension(16, 18));
    private static final TextureBlitData CHARGE_SEGMENT = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 74), new Dimension(16, 6));
    private static final TextureBlitData CONNECTION_TOP = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 48), new Dimension(16, 4));
    private static final TextureBlitData CONNECTION_BOTTOM = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 52), new Dimension(16, 4));
    private final Position pos;
    private final int height;
    private final StorageScreenBase<?> screen;
    private static final int TOP_BAR_COLOR = 0xFF1A1A;
    private static final int BOTTOM_BAR_COLOR = 0xFFFF40;

    public BatteryInventoryPart(int upgradeSlot, BatteryUpgradeContainer container, Position pos, int height, StorageScreenBase<?> screen) {
        super(upgradeSlot, container);
        this.pos = pos;
        this.height = height;
        this.screen = screen;
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY) {
        int i;
        GuiHelper.blit(poseStack, this.getTankLeft(), this.pos.y(), TANK_BACKGROUND_TOP);
        int yOffset = 18;
        for (i = 0; i < (this.height - 36) / 18; ++i) {
            GuiHelper.blit(poseStack, this.getTankLeft(), this.pos.y() + yOffset, TANK_BACKGROUND_MIDDLE);
            yOffset += 18;
        }
        GuiHelper.blit(poseStack, this.getTankLeft(), this.pos.y() + yOffset, TANK_BACKGROUND_BOTTOM);
        yOffset = 0;
        for (i = 0; i < this.height / 18; ++i) {
            GuiHelper.blit(poseStack, this.getTankLeft() + 1, this.pos.y() + yOffset, OVERLAY);
            yOffset += 18;
        }
        this.renderCharge(poseStack);
        GuiHelper.blit(poseStack, this.getTankLeft() + 1, this.pos.y(), CONNECTION_TOP);
        GuiHelper.blit(poseStack, this.getTankLeft() + 1, this.pos.y() + this.height - 4, CONNECTION_BOTTOM);
    }

    private int getTankLeft() {
        return this.pos.x() + 9;
    }

    @Override
    public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
        if (mouseX < (double)(this.screen.getGuiLeft() + this.getTankLeft()) || mouseX >= (double)(this.screen.getGuiLeft() + this.getTankLeft() + 18) || mouseY < (double)(this.screen.getGuiTop() + this.pos.y()) || mouseY >= (double)(this.screen.getGuiTop() + this.pos.y() + this.height)) {
            return false;
        }
        ItemStack cursorStack = ((StorageContainerMenuBase)this.screen.m_6262_()).m_142621_();
        if (!cursorStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        PacketHandler.INSTANCE.sendToServer(new TankClickMessage(this.upgradeSlot));
        return true;
    }

    @Override
    public void renderErrorOverlay(PoseStack matrixStack) {
        this.screen.renderOverlay(matrixStack, StorageScreenBase.ERROR_SLOT_COLOR, this.getTankLeft() + 1, this.pos.y() + 1, 16, this.height - 2);
    }

    @Override
    public void renderTooltip(StorageScreenBase<?> screen, PoseStack poseStack, int mouseX, int mouseY) {
        int screenX = screen.getGuiLeft() + this.pos.x() + 10;
        int screenY = screen.getGuiTop() + this.pos.y() + 1;
        if (mouseX >= screenX && mouseX < screenX + 16 && mouseY >= screenY && mouseY < screenY + this.height - 2) {
            int energyStored = ((BatteryUpgradeContainer)this.container).getEnergyStored();
            int maxEnergyStored = ((BatteryUpgradeContainer)this.container).getMaxEnergyStored();
            ArrayList<TranslatableComponent> tooltip = new ArrayList<TranslatableComponent>();
            tooltip.add(new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeKey("battery.contents_tooltip"), new Object[]{String.format("%,d", energyStored), String.format("%,d", maxEnergyStored)}));
            screen.m_169388_(poseStack, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderCharge(PoseStack matrixStack) {
        int energyStored = ((BatteryUpgradeContainer)this.container).getEnergyStored();
        int maxEnergyStored = ((BatteryUpgradeContainer)this.container).getMaxEnergyStored();
        int segmentHeight = CHARGE_SEGMENT.getHeight();
        int numberOfSegments = this.height / segmentHeight;
        int displayLevel = (int)((float)numberOfSegments * ((float)energyStored / (float)maxEnergyStored));
        int finalRed = 255;
        int finalGreen = 26;
        int finalBlue = 26;
        int initialRed = 255;
        int initialGreen = 255;
        int initialBlue = 64;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        for (int i = 0; i < displayLevel; ++i) {
            float percentage = (float)i / (float)(numberOfSegments - 1);
            int red = (int)((float)initialRed * (1.0f - percentage) + (float)finalRed * percentage);
            int green = (int)((float)initialGreen * (1.0f - percentage) + (float)finalGreen * percentage);
            int blue = (int)((float)initialBlue * (1.0f - percentage) + (float)finalBlue * percentage);
            int color = red << 16 | green << 8 | blue | 0xFF000000;
            GuiHelper.coloredBlit(matrix, this.getTankLeft() + 1, this.pos.y() + this.height - (i + 1) * segmentHeight, CHARGE_SEGMENT, color);
        }
    }
}

