/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.moddingplayground.twigs.entity.StrippedBambooBoatEntity;

@OnlyIn(value=Dist.CLIENT)
public class StrippedBambooBoatRenderer
extends EntityRenderer<StrippedBambooBoatEntity> {
    private final Map<StrippedBambooBoatEntity.BoatType, Pair<ResourceLocation, BoatModel>> boatResources = (Map)Stream.of(StrippedBambooBoatEntity.BoatType.values()).collect(ImmutableMap.toImmutableMap(type -> type, boatType -> Pair.of((Object)new ResourceLocation("twigs", "textures/entity/boat/" + boatType.getName() + ".png"), (Object)new BoatModel(context.m_174023_(StrippedBambooBoatRenderer.createBoatLayerLocation(boatType))))));

    public StrippedBambooBoatRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public static ModelLayerLocation createBoatLayerLocation(StrippedBambooBoatEntity.BoatType type) {
        return new ModelLayerLocation(new ResourceLocation("twigs", "boat/" + type.getName()), "main");
    }

    public void render(StrippedBambooBoatEntity entity, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferSource, int packedLight) {
        float f2;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.375, 0.0);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        float f = (float)entity.m_38385_() - partialTicks;
        float f1 = entity.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = entity.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entity.m_38352_(partialTicks), true));
        }
        Pair<ResourceLocation, BoatModel> pair = this.boatResources.get((Object)entity.getBoatTypeDropItem());
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        BoatModel boatmodel = (BoatModel)pair.getSecond();
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        boatmodel.m_6973_((Boat)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(boatmodel.m_103119_(resourcelocation));
        boatmodel.m_7695_(matrixStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer vertexconsumer1 = bufferSource.m_6299_(RenderType.m_110478_());
            boatmodel.m_102282_().m_104301_(matrixStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
        }
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, matrixStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(StrippedBambooBoatEntity entity) {
        return (ResourceLocation)this.boatResources.get((Object)entity.getBoatTypeDropItem()).getFirst();
    }
}

